/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorObjectFactory;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.TableGenerationConfiguration;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg.MaxMinGenerator;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.GenerationModel;
import org.gcube.application.aquamaps.ecomodelling.generators.processing.DistributionGenerator;
import org.gcube.application.aquamaps.ecomodelling.generators.processing.EnvelopeGenerator;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dataanalysis.ecoengine.evaluation.bioclimate.InterpolateTables;

public class BatchGenerator
implements BatchGeneratorI {
    private static final GCUBELog logger = new GCUBELog(BatchGenerator.class);
    private EngineConfiguration e = new EngineConfiguration();
    private static final int NUM_OF_THREADS = 2;
    private DistributionGenerator dg = null;
    private EnvelopeGenerator eg = null;
    private Integer internalId;
    private InterpolateTables interpolator = null;
    private BatchGeneratorObjectFactory.BatchPoolType type;

    public BatchGenerator(String path, DBDescriptor credentials) {
        this.setConfiguration(path, credentials);
    }

    @Override
    public String generateHSPECTable(String hcaf, String hspen, String filteredHSPEN, AlgorithmType type, Boolean iscloud, String endpoint) throws Exception {
        return this.generateHSPEC(hcaf, hspen, filteredHSPEN, type.equals((Object)AlgorithmType.NativeRange) || type.equals((Object)AlgorithmType.NativeRange2050), type.equals((Object)AlgorithmType.SuitableRange2050) || type.equals((Object)AlgorithmType.NativeRange2050), 2, "", "", "", new HashMap<String, String>(), GenerationModel.AQUAMAPS, SourceManager.getToUseTableStore());
    }

    @Override
    public void setConfiguration(String path, DBDescriptor credentials) {
        logger.trace((Object)("***** SETTING BATCH GENERATOR CONFIGURATION (path : " + path + ")"));
        this.e.setConfigPath(path);
        this.e.setDatabaseUserName(credentials.getUser());
        logger.trace((Object)("user : " + credentials.getUser()));
        this.e.setDatabasePassword(credentials.getPassword());
        logger.trace((Object)("user : " + credentials.getPassword()));
        String url = "jdbc:postgresql:" + credentials.getEntryPoint();
        this.e.setDatabaseURL(url);
        this.e.setCreateTable(Boolean.valueOf(true));
        logger.trace((Object)("passed argument : user " + this.e.getDatabaseUserName()));
        logger.trace((Object)("passed argument : password " + this.e.getDatabasePassword()));
        logger.trace((Object)("passed argument : url " + this.e.getDatabaseURL()));
        logger.trace((Object)("passed argument : threads num " + this.e.getNumberOfThreads()));
    }

    public BatchGenerator(BatchGeneratorObjectFactory.BatchPoolType type) {
        this.internalId = this.hashCode();
        this.type = type;
        logger.trace((Object)("Created batch " + (Object)((Object)type) + "generator with ID " + this.internalId));
    }

    @Override
    public BatchGeneratorObjectFactory.BatchPoolType getType() {
        return this.type;
    }

    @Override
    public EnvironmentalExecutionReportItem getReport(boolean getResourceInfo) {
        EnvironmentalExecutionReportItem toReturn = null;
        if (this.dg != null) {
            toReturn = new EnvironmentalExecutionReportItem();
            toReturn.setPercent(Double.valueOf(this.dg.getStatus()));
            if (getResourceInfo) {
                toReturn.setResourceLoad(this.dg.getResourceLoad());
                toReturn.setResourcesMap(this.dg.getResources());
                toReturn.setElaboratedSpecies(this.dg.getSpeciesLoad());
            }
        } else if (this.eg != null) {
            toReturn = new EnvironmentalExecutionReportItem();
            toReturn.setPercent(Double.valueOf(this.eg.getStatus()));
            if (getResourceInfo) {
                toReturn.setResourceLoad(this.eg.getResourceLoad());
                toReturn.setResourcesMap(this.eg.getResources());
                toReturn.setElaboratedSpecies(this.eg.getSpeciesLoad());
            }
        } else if (this.interpolator != null) {
            toReturn = new EnvironmentalExecutionReportItem();
            toReturn.setPercent(new Double(this.interpolator.getStatus()));
        }
        return toReturn;
    }

    @Override
    public int getReportId() {
        return this.internalId;
    }

    @Override
    public void generateTable(final TableGenerationConfiguration configuration) throws Exception {
        final BatchGenerator instance = this;
        Thread t = new Thread(){

            @Override
            public void run() {
                ArrayList<String> toReturn = new ArrayList<String>();
                try {
                    try {
                        switch (configuration.getLogic()) {
                            case HSPEC: {
                                toReturn.add(BatchGenerator.this.generateHSPEC(configuration.getSources().get(ResourceType.HCAF).get(0).getTableName(), configuration.getSources().get(ResourceType.HSPEN).get(0).getTableName(), configuration.getMaxMinHspenTable(), configuration.getAlgorithm().equals((Object)AlgorithmType.NativeRange) || configuration.getAlgorithm().equals((Object)AlgorithmType.NativeRange2050), configuration.getAlgorithm().equals((Object)AlgorithmType.SuitableRange2050) || configuration.getAlgorithm().equals((Object)AlgorithmType.NativeRange2050), configuration.getPartitionsNumber(), configuration.getBackendUrl(), configuration.getAuthor(), configuration.getExecutionEnvironment(), configuration.getConfiguration(), configuration.getSubmissionBackend().equalsIgnoreCase(ServiceContext.getContext().getName()) ? GenerationModel.AQUAMAPS : GenerationModel.REMOTE_AQUAMAPS, SourceManager.getToUseTableStore()));
                                break;
                            }
                            case HSPEN: {
                                toReturn.add(BatchGenerator.this.generateHSPEN(configuration.getSources().get(ResourceType.HCAF).get(0).getTableName(), configuration.getSources().get(ResourceType.HSPEN).get(0).getTableName(), configuration.getSources().get(ResourceType.OCCURRENCECELLS).get(0).getTableName(), configuration.getPartitionsNumber(), configuration.getBackendUrl(), configuration.getAuthor(), configuration.getExecutionEnvironment(), configuration.getConfiguration(), EnvelopeModel.AQUAMAPS, SourceManager.getToUseTableStore()));
                                break;
                            }
                            case HCAF: {
                                int firstHcaf = 0;
                                int secondHcaf = 0;
                                int firstHcafTime = 0;
                                int secondHcafTime = 0;
                                int numInterpolations = 0;
                                for (Field f : configuration.getAdditionalParameters()) {
                                    if (f.getName().equals("FIRST_HCAF_ID")) {
                                        firstHcaf = f.getValueAsInteger();
                                        continue;
                                    }
                                    if (f.getName().equals("SECOND_HCAF_ID")) {
                                        secondHcaf = f.getValueAsInteger();
                                        continue;
                                    }
                                    if (f.getName().equals("FIRST_HCAF_TIME")) {
                                        firstHcafTime = f.getValueAsInteger();
                                        continue;
                                    }
                                    if (f.getName().equals("SECOND_HCAF_TIME")) {
                                        secondHcafTime = f.getValueAsInteger();
                                        continue;
                                    }
                                    if (!f.getName().equals("NUM_INTERPOLATIONS")) continue;
                                    numInterpolations = f.getValueAsInteger();
                                }
                                if (firstHcaf == 0) {
                                    throw new Exception("Unable to select first HCAF");
                                }
                                if (secondHcaf == 0) {
                                    throw new Exception("Unable to select second HCAF");
                                }
                                if (firstHcafTime == 0) {
                                    throw new Exception("Unable to detect first HCAF time");
                                }
                                if (secondHcafTime == 0) {
                                    throw new Exception("Unable to detect second HCAF time");
                                }
                                if (numInterpolations == 0) {
                                    throw new Exception("Unable to detect num Interpolations");
                                }
                                Resource first = null;
                                Resource second = null;
                                for (Resource hcaf : configuration.getSources().get(ResourceType.HCAF)) {
                                    if (hcaf.getSearchId() == firstHcaf) {
                                        first = hcaf;
                                        continue;
                                    }
                                    if (hcaf.getSearchId() != secondHcaf) continue;
                                    second = hcaf;
                                }
                                if (first == null) {
                                    throw new Exception("First hcaf not found, passed id : " + firstHcaf);
                                }
                                if (second == null) {
                                    throw new Exception("Second hcaf not found, passed id : " + secondHcaf);
                                }
                                toReturn.addAll(BatchGenerator.this.generateHCAF(first.getTableName(), second.getTableName(), numInterpolations, InterpolateTables.INTERPOLATIONFUNCTIONS.valueOf((String)("" + configuration.getAlgorithm())), firstHcafTime, secondHcafTime, SourceManager.getToUseTableStore()));
                            }
                        }
                        Collections.sort(toReturn);
                        configuration.registerGeneratedSourcesCallback(toReturn);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unexpected error, request was " + configuration));
                        configuration.notifyError(e);
                        configuration.release(instance);
                    }
                }
                finally {
                    configuration.release(instance);
                }
            }
        };
        t.start();
    }

    private String generateHSPEC(String hcafTable, String hspenTable, String maxMinHspen, boolean isNative, boolean is2050, int threadNum, String calculatorUrl, String calculationUser, String executioneEnvironment, HashMap<String, String> calculationConfig, GenerationModel model, String tableStore) throws Exception {
        String toGenerate = ServiceUtils.generateId("hspec", "");
        logger.debug((Object)("Current generator instance is " + this.toString()));
        logger.debug((Object)("Using Engine " + this.e.toString()));
        logger.trace((Object)("generating hspec : " + toGenerate));
        logger.trace((Object)("hspen : " + hspenTable));
        logger.trace((Object)("MAX MIN LAT To use : " + maxMinHspen));
        logger.trace((Object)("hcaf : " + hcafTable));
        logger.trace((Object)("native : " + isNative));
        logger.trace((Object)("2050 : " + is2050));
        logger.trace((Object)("thread N : " + threadNum));
        logger.trace((Object)("url : " + calculatorUrl));
        logger.trace((Object)("calculation user : " + calculationUser));
        logger.trace((Object)("model : " + model));
        logger.trace((Object)("environment : " + executioneEnvironment));
        logger.trace((Object)("config values : " + calculationConfig.size()));
        try {
            this.e.setHspenTable(hspenTable);
            this.e.setHcafTable(hcafTable);
            this.e.setDistributionTable(toGenerate);
            this.e.setNativeGeneration(Boolean.valueOf(isNative));
            this.e.setType2050(Boolean.valueOf(is2050));
            this.e.setMaxminLatTable(maxMinHspen);
            this.e.setGenerator(model);
            this.e.setRemoteCalculator(calculatorUrl);
            this.e.setServiceUserName(calculationUser);
            this.e.setRemoteEnvironment(executioneEnvironment);
            this.e.setNumberOfThreads(Integer.valueOf(threadNum));
            this.e.setGeneralProperties(calculationConfig);
            this.e.setGenerator(model);
            this.e.setTableStore(tableStore);
            this.dg = new DistributionGenerator(this.e);
            logger.debug((Object)"Distribution Generator inited, gonna execute generation.. ");
            this.dg.generateHSPEC();
            return toGenerate;
        }
        catch (Exception e) {
            logger.warn((Object)("Execution failed, exception was " + e.getMessage()));
            this.cleanDirtyTables(toGenerate);
            throw e;
        }
    }

    private String generateHSPEN(String hcafTable, String hspenTable, String occurrenceCellsTable, int threadNum, String calculatorUrl, String calculationUser, String executioneEnvironment, HashMap<String, String> calculationConfig, EnvelopeModel model, String tableStore) throws Exception {
        String toGenerate = ServiceUtils.generateId("hspen", "");
        logger.debug((Object)("Current generator instance is " + this.toString()));
        logger.debug((Object)("Using Engine " + this.e.toString()));
        logger.trace((Object)("generating hspen : " + toGenerate));
        logger.trace((Object)("hspen : " + hspenTable));
        logger.trace((Object)("hcaf : " + hcafTable));
        logger.trace((Object)("thread N : " + threadNum));
        logger.trace((Object)("url : " + calculatorUrl));
        logger.trace((Object)("calculation user : " + calculationUser));
        logger.trace((Object)("model : " + model));
        logger.trace((Object)("environment : " + executioneEnvironment));
        logger.trace((Object)("config values : " + calculationConfig.size()));
        try {
            this.e.setOriginHspenTable(hspenTable);
            this.e.setHspenTable(toGenerate);
            this.e.setHcafTable(hcafTable);
            this.e.setOccurrenceCellsTable(occurrenceCellsTable);
            this.e.setEnvelopeGenerator(model);
            this.e.setRemoteCalculator(calculatorUrl);
            this.e.setServiceUserName(calculationUser);
            this.e.setRemoteEnvironment(executioneEnvironment);
            this.e.setNumberOfThreads(Integer.valueOf(threadNum));
            this.e.setGeneralProperties(calculationConfig);
            this.e.setTableStore(tableStore);
            this.eg = new EnvelopeGenerator(this.e);
            this.eg.reGenerateEnvelopes();
            logger.trace((Object)"Generating Max Min table..");
            MaxMinGenerator maxmin = new MaxMinGenerator(this.e);
            maxmin.populatemaxminlat(toGenerate);
            return toGenerate;
        }
        catch (Exception e) {
            this.cleanDirtyTables(toGenerate);
            throw e;
        }
    }

    private List<String> generateHCAF(String startingHCAF, String endHCAF, int numIntervals, InterpolateTables.INTERPOLATIONFUNCTIONS function, int startingTime, int endTime, String tableStore) throws Exception {
        logger.debug((Object)("Current generator instance is " + this.toString()));
        logger.debug((Object)("Using Engine " + this.e.toString()));
        ArrayList<String> toReturn = new ArrayList<String>();
        this.interpolator = new InterpolateTables(this.e.getConfigPath(), ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.TABLES), this.e.getDatabaseURL(), this.e.getDatabaseUserName(), this.e.getDatabasePassword());
        this.interpolator.interpolate(startingHCAF, endHCAF, numIntervals, function, startingTime, endTime);
        toReturn.addAll(Arrays.asList(this.interpolator.getInterpolatedTables()));
        toReturn.remove(0);
        toReturn.remove(toReturn.size() - 1);
        return toReturn;
    }

    private void cleanDirtyTables(String toDelete) {
        block12: {
            DBSession session = null;
            try {
                try {
                    session = DBSession.getInternalDBSession();
                    session.dropTable(toDelete);
                }
                catch (Exception e) {
                    logger.fatal((Object)("Unexpected Exception while trying to delete table " + toDelete), (Throwable)e);
                    if (session == null) break block12;
                    try {
                        session.close();
                    }
                    catch (Exception e2) {
                        logger.fatal((Object)"Unable to close connection ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception e) {
                        logger.fatal((Object)"Unable to close connection ", (Throwable)e);
                    }
                }
            }
        }
    }
}

