/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.CustomQueryManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.CustomQueryDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConstructurThread
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(QueryConstructurThread.class);
    private String userId;
    private Operation op;
    private String table;
    private String queryString;

    public QueryConstructurThread(String userId, Operation op, String query, String tableName) {
        super((Object)((Object)op) + "_" + userId);
        this.userId = userId;
        this.op = op;
        this.table = tableName;
        this.queryString = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DBSession session = null;
        try {
            switch (this.op) {
                case CREATE: {
                    CustomQueryDescriptor desc = CustomQueryManager.getDescriptor(this.userId);
                    desc.setStatus(ExportStatus.ONGOING);
                    CustomQueryManager.updateDescriptor(desc);
                    try {
                        session = DBSession.getInternalDBSession();
                        logger.trace("Creating view [ " + this.table + " ]for " + this.userId + "'s query [ " + this.queryString + " ]");
                        session.executeUpdate("CREATE TABLE " + this.table + " AS ( " + this.queryString + " )");
                        logger.trace("Getting meta for custom table " + this.table);
                        desc.setRows(Long.valueOf(session.getTableCount(this.table)));
                        ResultSet rsColumns = session.executeQuery("SELECT * FROM " + this.table + " LIMIT 1 OFFSET 0");
                        ResultSetMetaData meta = rsColumns.getMetaData();
                        for (int i = 1; i <= meta.getColumnCount(); ++i) {
                            desc.getFields().add(new Field(meta.getColumnName(i), "", FieldType.STRING));
                        }
                        desc.setStatus(ExportStatus.COMPLETED);
                        CustomQueryManager.updateDescriptor(desc);
                    }
                    catch (Exception e) {
                        desc.setStatus(ExportStatus.ERROR);
                        desc.setErrorMessage(e.getMessage());
                        CustomQueryManager.updateDescriptor(desc);
                    }
                    break;
                }
                case DELETE: {
                    logger.trace("Dropping " + this.userId + "'s custom query view " + this.table + ", query was [ " + this.queryString + " ]");
                    session = DBSession.getInternalDBSession();
                    session.dropTable(this.table);
                    break;
                }
                default: {
                    throw new Exception("Operation not defined");
                }
            }
            logger.trace("DONE");
        }
        catch (Exception e) {
            logger.error("Unable to " + (Object)((Object)this.op) + " table", (Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    logger.error("Unable to close session", (Throwable)e);
                }
            }
        }
    }

    public static enum Operation {
        DELETE,
        CREATE;

    }
}

