/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AquaMapsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.CellManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SpeciesManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.JobExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.SimpleGenerator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.AquaMapsServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CalculateEnvelopeRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CalculateEnvelopefromCellSelectionRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetPhylogenyRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetSpeciesByFiltersRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetSpeciesEnvelopeRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BoundingBox;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Cell;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HspenFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AreaType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube_system.namespaces.application.aquamaps.types.AquaMap;
import org.gcube_system.namespaces.application.aquamaps.types.FieldArray;
import org.gcube_system.namespaces.application.aquamaps.types.FilterArray;
import org.gcube_system.namespaces.application.aquamaps.types.Job;
import org.gcube_system.namespaces.application.aquamaps.types.Submitted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AquaMapsService
extends GCUBEPortType
implements AquaMapsServicePortType {
    private static Logger logger = LoggerFactory.getLogger(AquaMapsService.class);

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String getPhylogeny(GetPhylogenyRequestType req) throws GCUBEFault {
        try {
            Field toSelect = new Field(req.getToSelect());
            return SpeciesManager.getJSONTaxonomy(toSelect, Field.load((FieldArray)req.getFieldList()), req.getPagedRequestSettings());
        }
        catch (Exception e) {
            logger.error("Unable to get Taxonomy ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public int deleteSubmitted(StringArray submittedIds) throws GCUBEFault {
        int toReturn = 0;
        if (submittedIds != null && submittedIds.getItems() != null) {
            for (String id : submittedIds.getItems()) {
                try {
                    int toDelete = Integer.parseInt(id);
                    toReturn += SubmittedManager.delete(toDelete);
                }
                catch (Exception e) {
                    logger.error("cannot delete " + id, (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    public FieldArray calculateEnvelope(CalculateEnvelopeRequestType req) throws GCUBEFault {
        logger.trace("Serving calculateEnvelope");
        try {
            BoundingBox bb = new BoundingBox();
            if (req.isUseBounding()) {
                bb.setE(Double.valueOf(req.getBoundingEast()));
                bb.setW(Double.valueOf(req.getBoundingWest()));
                bb.setN(Double.valueOf(req.getBoundingNorth()));
                bb.setS(Double.valueOf(req.getBoundingSouth()));
            }
            ArrayList<Area> areas = new ArrayList<Area>();
            if (req.isUseFAO()) {
                for (String code : req.getFaoAreas().split(",")) {
                    areas.add(new Area(AreaType.FAO, code.trim()));
                }
            }
            Set<Cell> foundCells = CellManager.calculateGoodCells(bb, areas, req.getSpeciesID(), SourceManager.getDefaultId(ResourceType.HCAF));
            logger.trace("found " + foundCells.size() + " cells");
            Species species = SpeciesManager.getSpeciesById(true, true, req.getSpeciesID(), SourceManager.getDefaultId(ResourceType.HSPEN));
            if (req.isUseBottomSeaTempAndSalinity()) {
                species.getFieldbyName(HspenFields.layer + "").setValue("b");
            } else {
                species.getFieldbyName(HspenFields.layer + "").setValue("u");
            }
            SimpleGenerator generator = new SimpleGenerator(ServiceContext.getContext().getEcoligicalConfigDir().getAbsolutePath() + File.separator);
            for (Field f : generator.getEnvelope(species, foundCells)) {
                species.addField(f);
            }
            return species.extractEnvelope().toFieldArray();
        }
        catch (Exception e) {
            logger.error("General Exception, unable to serve request", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public FieldArray calculateEnvelopefromCellSelection(CalculateEnvelopefromCellSelectionRequestType request) throws GCUBEFault {
        logger.trace("Serving calculateEnvelopefromCellSelection for speciesID : " + request.getSpeciesID());
        try {
            Set<Cell> selected = CellManager.getCellsByIds(true, request.getSpeciesID(), true, SourceManager.getDefaultId(ResourceType.HCAF), request.getCellIds().getItems());
            Species spec = SpeciesManager.getSpeciesById(true, true, request.getSpeciesID(), SourceManager.getDefaultId(ResourceType.HSPEN));
            SimpleGenerator generator = new SimpleGenerator(ServiceContext.getContext().getEcoligicalConfigDir().getAbsolutePath() + File.separator);
            for (Field f : generator.getEnvelope(spec, selected)) {
                spec.addField(f);
            }
            return spec.extractEnvelope().toFieldArray();
        }
        catch (Exception e) {
            logger.error("General Exception, unable to serve request", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String submitJob(Job req) throws GCUBEFault {
        try {
            logger.trace("Serving submit job " + req.getName());
            logger.trace("Forcing group enabling if layers requested");
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job job = new org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job(req);
            boolean enableGis = false;
            for (AquaMapsObject obj : job.getAquaMapsObjectList()) {
                if (!obj.getGis().booleanValue()) continue;
                enableGis = true;
                break;
            }
            job.setIsGis(Boolean.valueOf(enableGis));
            return JobExecutionManager.insertJobExecutionRequest(job, false) + "";
        }
        catch (Exception e) {
            logger.error("Unable to execute Job " + req.getName(), (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public FieldArray getSpeciesEnvelop(GetSpeciesEnvelopeRequestType arg0) throws GCUBEFault {
        logger.trace("serving get Species envelope");
        try {
            Species selected = SpeciesManager.getSpeciesById(true, true, arg0.getSpeciesId(), arg0.getHspenId());
            return Field.toStubsVersion((Collection)selected.getAttributesList());
        }
        catch (Exception e) {
            logger.error("General Exception, unable to serve request", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String getSpeciesByFilters(GetSpeciesByFiltersRequestType req) throws GCUBEFault {
        logger.trace("Serving getSpecies by filters");
        try {
            return SpeciesManager.getJSONList(req.getPagedRequestSettings(), Filter.load((FilterArray)req.getGenericSearchFilters()), Filter.load((FilterArray)req.getSpecieficFilters()), req.getHspen());
        }
        catch (Exception e) {
            logger.error("General Exception, unable to serve request", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public VOID markSaved(StringArray ids) throws GCUBEFault {
        try {
            if (ids != null && ids.getItems() != null) {
                for (String id : ids.getItems()) {
                    SubmittedManager.markSaved(Integer.parseInt(id));
                }
            }
            return new VOID();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new GCUBEFault();
        }
    }

    public Submitted loadSubmittedById(int arg0) throws RemoteException, GCUBEFault {
        try {
            logger.trace("Loading submitted id : " + arg0);
            ArrayList<Field> conditions = new ArrayList<Field>();
            conditions.add(new Field(SubmittedFields.searchid + "", arg0 + "", FieldType.INTEGER));
            return SubmittedManager.getList(conditions).get(0).toStubsVersion();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new GCUBEFault(new String[]{"Impossible to load submitted : " + e.getMessage()});
        }
    }

    public AquaMap getObject(int arg0) throws RemoteException, GCUBEFault {
        try {
            AquaMapsObject obj = AquaMapsManager.loadObject(arg0, true, true);
            return obj.toStubsVersion();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new GCUBEFault(new String[]{"Impossible to load Object from Publisher : " + e.getMessage()});
        }
    }

    public String getSpeciesByFiltersASCSV(GetSpeciesByFiltersRequestType arg0) throws RemoteException, GCUBEFault {
        logger.trace("Serving getSpecies by filters");
        try {
            File toExport = SpeciesManager.getCSVList(Filter.load((FilterArray)arg0.getGenericSearchFilters()), Filter.load((FilterArray)arg0.getSpecieficFilters()), arg0.getHspen());
            GCUBEScope scope = ServiceContext.getContext().getScope();
            logger.trace("Caller scope is " + scope);
            RSWrapper wrapper = new RSWrapper();
            wrapper.add(toExport);
            String locator = wrapper.getLocator().toString();
            logger.trace("Added file to locator " + locator);
            return locator;
        }
        catch (Exception e) {
            logger.error("General Exception, unable to serve request", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }
}

