/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.publishing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSetUtils {
    static final Logger logger = LoggerFactory.getLogger(FileSetUtils.class);
    private static final Map<String, String> imageFileAndName = new HashMap<String, String>();

    static {
        imageFileAndName.put("_map_pic.jpg", "Earth");
        imageFileAndName.put("_afr.jpg", "Continent View : Africa");
        imageFileAndName.put("_asia.jpg", "Continent View : Asia");
        imageFileAndName.put("_aus.jpg", "Continent View : Australia");
        imageFileAndName.put("_eur.jpg", "Continent View : Europa");
        imageFileAndName.put("_nAm.jpg", "Continent View : North America");
        imageFileAndName.put("_sAm.jpg", "Continent View : South America");
        imageFileAndName.put("_xmapAtlan.jpg", "Ocean View : Atlantic");
        imageFileAndName.put("_xmapI.jpg", "Ocean View : Indian");
        imageFileAndName.put("_xmapN.jpg", "Pole View : Artic");
        imageFileAndName.put("_xmapNAtlan.jpg", "Ocean View : North Atlantic");
        imageFileAndName.put("_xmapP.jpg", "Ocean View : Pacific");
        imageFileAndName.put("_xmapS.jpg", "Pole View : Antarctic");
        imageFileAndName.put("_xmapSAtlan.jpg", "Ocean View : South Atlantic");
    }

    public static final String getTempMapsFolder() {
        String tempFolderPath = String.valueOf(System.getenv("GLOBUS_LOCATION")) + File.separator + "c-squaresOnGrid/maps/tmp_maps/";
        File f = new File(tempFolderPath);
        if (!f.exists()) {
            f.mkdirs();
        }
        return tempFolderPath;
    }

    public static Map<String, String> generateFileMap(String csqString, String objectTitle) throws Exception {
        int generationResponse = FileSetUtils.generateImages(csqString);
        if (generationResponse == 0) {
            return FileSetUtils.getToPublishList(objectTitle);
        }
        throw new Exception("Perl Execution returned " + generationResponse);
    }

    public static List<String> getTempFiles(String objectTitle) {
        objectTitle = objectTitle.replace(" ", "_");
        ArrayList<String> toReturn = new ArrayList<String>();
        String tmpBasePath = FileSetUtils.getTempMapsFolder();
        toReturn.add(String.valueOf(tmpBasePath) + objectTitle + File.separator);
        toReturn.add(String.valueOf(tmpBasePath) + "csq_map127.0.0.1_" + objectTitle + "_map_pic.jpg");
        return toReturn;
    }

    static String createClusteringFile(int objId, int jobId, StringBuilder[] csq_str, String header) throws Exception {
        header = header.replace(" ", "_");
        String to_out = "color=FFFF84 fill=Y color2=FFDE6B fill2=Y color3=FFAD6B fill3=Y color4=FF6B6B fill4=Y color5=DE4242 fill5=Y " + (csq_str[0].toString().compareTo("") != 0 ? " csq=" + csq_str[0].toString() : " csq=0000:000:0") + (csq_str[1].toString().compareTo("") != 0 ? " csq2=" + csq_str[1].toString() : "") + (csq_str[2].toString().compareTo("") != 0 ? " csq3=" + csq_str[2].toString() : "") + (csq_str[3].toString().compareTo("") != 0 ? " csq4=" + csq_str[3].toString() : "") + (csq_str[4].toString().compareTo("") != 0 ? " csq5=" + csq_str[4].toString() : "") + " header=" + header + " enlarge=7200 title=" + header + " dilate=N cSub popup=Y landmask=1 filedesc=map_pic legend=  mapsize=large";
        String fileName = String.valueOf(objId) + "_clustering";
        try {
            File d = new File(String.valueOf(ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.CLUSTERS)) + File.separator + jobId);
            JobManager.addToDeleteTempFolder(jobId, d.getAbsolutePath());
            d.mkdirs();
            File f = new File(d, fileName);
            f.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(to_out);
            out.close();
            String toReturn = f.getAbsolutePath();
            logger.debug("Clustering string saved into " + toReturn);
            return toReturn;
        }
        catch (Exception e) {
            logger.error("Unable to write clutering file ", (Throwable)e);
            throw e;
        }
    }

    static Map<String, String> getToPublishList(String header) throws Exception {
        header = header.replace(" ", "_");
        String tempFolderBasePath = FileSetUtils.getTempMapsFolder();
        HashMap<String, String> toReturn = new HashMap<String, String>();
        String basePath = String.valueOf(tempFolderBasePath) + header + File.separator;
        logger.trace("Checking generated images...");
        logger.trace("base path : " + basePath);
        logger.trace("header is " + header);
        File f1 = new File(String.valueOf(tempFolderBasePath) + "csq_map127.0.0.1_" + header + "_map_pic.jpg");
        logger.trace("Checking file " + f1.getAbsolutePath());
        if (f1.exists()) {
            toReturn.put("Earth", f1.getAbsolutePath());
        }
        for (String string : imageFileAndName.keySet()) {
            File f2 = new File(String.valueOf(basePath) + header + string);
            logger.trace("Checking file " + f2.getAbsolutePath());
            if (!f2.exists()) continue;
            toReturn.put(imageFileAndName.get(string), f2.getAbsolutePath());
        }
        if (ServiceContext.getContext().getPropertyAsBoolean("ENABLE_SCRIPT_LOGGING").booleanValue()) {
            for (Map.Entry entry : toReturn.entrySet()) {
                logger.trace("Found " + (String)entry.getKey() + " @ " + (String)entry.getValue());
            }
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int generateImages(String file) throws Exception {
        try (BufferedReader input = null;){
            logger.trace("Checking perl...");
            String perlFileLocation = String.valueOf(System.getenv("GLOBUS_LOCATION")) + File.separator + "c-squaresOnGrid" + File.separator + "bin" + File.separator + "cs_mapMod.pl";
            File perlFile = new File(perlFileLocation);
            if (!perlFile.exists()) throw new Exception("Perl File " + perlFileLocation + " NOT FOUND, unable to proceed");
            FileSetUtils.getTempMapsFolder();
            logger.trace("Checking file existance... : " + file);
            File clusteringFile = new File(file);
            if (clusteringFile.exists() && clusteringFile.canRead()) {
                Runtime rt = Runtime.getRuntime();
                String[] cmdLine = new String[]{"/usr/bin/perl", "-w", perlFileLocation, file};
                Process p = rt.exec(cmdLine);
                input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (!ServiceContext.getContext().getPropertyAsBoolean("ENABLE_SCRIPT_LOGGING").booleanValue()) continue;
                    logger.trace(line);
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    logger.trace("Perl process exited");
                }
                int value = p.exitValue();
                logger.trace("Exit value is " + value);
                p.destroy();
                int n = value;
                return n;
            }
            throw new Exception("No access to clustering file " + file);
        }
    }

    public static StringBuilder[] clusterize(ResultSet rs, int maxIndex, int toClusterIndex, int probabilityIndex, boolean bioDiversity) throws SQLException {
        StringBuilder csq_str1 = new StringBuilder();
        StringBuilder csq_str2 = new StringBuilder();
        StringBuilder csq_str3 = new StringBuilder();
        StringBuilder csq_str4 = new StringBuilder();
        StringBuilder csq_str5 = new StringBuilder();
        if (rs.first()) {
            double max = 0.0;
            double r1 = 0.0;
            double r2 = 0.0;
            double r3 = 0.0;
            double r4 = 0.0;
            if (bioDiversity) {
                max = rs.getDouble(maxIndex);
                r1 = Math.round(Math.pow(10.0, Math.log10(max) / 5.0));
                r2 = Math.round(Math.pow(10.0, 2.0 * Math.log10(max) / 5.0));
                r3 = Math.round(Math.pow(10.0, 3.0 * Math.log10(max) / 5.0));
                r4 = Math.round(Math.pow(10.0, 4.0 * Math.log10(max) / 5.0));
            } else {
                r1 = 0.2;
                r2 = 0.4;
                r3 = 0.6;
                r4 = 0.8;
            }
            logger.debug("Clustering by " + r1 + " , " + r2 + " , " + r3 + " , " + r4);
            do {
                double currentValue = rs.getDouble(probabilityIndex);
                String toAppendCode = rs.getString(toClusterIndex);
                if (currentValue > 0.0 && currentValue <= r1) {
                    if (csq_str1.length() > 1) {
                        csq_str1.append("|" + toAppendCode);
                        continue;
                    }
                    csq_str1.append(toAppendCode);
                    continue;
                }
                if (currentValue > r1 && currentValue <= r2) {
                    if (csq_str2.length() > 1) {
                        csq_str2.append("|" + toAppendCode);
                        continue;
                    }
                    csq_str2.append(toAppendCode);
                    continue;
                }
                if (currentValue > r2 && currentValue <= r3) {
                    if (csq_str3.length() > 1) {
                        csq_str3.append("|" + toAppendCode);
                        continue;
                    }
                    csq_str3.append(toAppendCode);
                    continue;
                }
                if (currentValue > r3 && currentValue <= r4) {
                    if (csq_str4.length() > 1) {
                        csq_str4.append("|" + toAppendCode);
                        continue;
                    }
                    csq_str4.append(toAppendCode);
                    continue;
                }
                if (!(currentValue > r4)) continue;
                if (csq_str5.length() > 1) {
                    csq_str5.append("|" + toAppendCode);
                    continue;
                }
                csq_str5.append(toAppendCode);
            } while (rs.next());
        } else {
            return null;
        }
        logger.trace("Clustering complete : cluster 1 size " + csq_str1.length() + "cluster 2 size " + csq_str2.length() + "cluster 3 size " + csq_str3.length() + "cluster 4 size " + csq_str4.length() + "cluster 5 size " + csq_str5.length());
        return new StringBuilder[]{csq_str1, csq_str2, csq_str3, csq_str4, csq_str5};
    }
}

