/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.publishing;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.util.FileUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AquaMapsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.JobManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SpeciesManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.AquaMapsObjectData;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.BiodiversityObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.DistributionObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.AquaMapsObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.FileSetUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.GenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.GISUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.LayerGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.StyleGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.HCAF_SFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.HSPECFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.gis.LayerType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ObjectType;
import org.gcube.application.aquamaps.publisher.MetaInformations;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.impl.datageneration.ObjectManager;
import org.gcube.application.aquamaps.publisher.impl.model.CoverageDescriptor;
import org.gcube.application.aquamaps.publisher.impl.model.File;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.FileType;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube.application.aquamaps.publisher.impl.model.WMSContext;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator<T>
implements ObjectManager<T> {
    static final Logger logger = LoggerFactory.getLogger(Generator.class);
    static final Publisher publisher = ServiceContext.getContext().getPublisher();
    private static final String GENERATION_DATA_TABLE = "generationdata";
    private static final String GENERATION_ID = "id";
    private static final String GENERATION_csv = "csv";
    private static final String GENERATION_max = "max";
    private static final String GENERATION_min = "min";
    private static final String GENERATION_csq = "csq";
    private static final String GENERATION_path = "path";
    private static final String GENERATION_SPECIES = "species";
    protected GenerationRequest request;
    protected Class<T> clazz;

    public Generator(GenerationRequest request, Class<T> toGenerateClazz) {
        this.request = request;
        this.clazz = toGenerateClazz;
    }

    public T generate() throws Exception {
        if (this.clazz.equals(FileSet.class)) {
            AquaMapsObjectExecutionRequest req = (AquaMapsObjectExecutionRequest)this.request;
            return (T)Generator.generateFileSet(Generator.getData(req), req.getObject());
        }
        if (this.clazz.equals(Layer.class)) {
            AquaMapsObjectExecutionRequest req = (AquaMapsObjectExecutionRequest)this.request;
            return (T)Generator.generateLayer(Generator.getData(req), req.getObject());
        }
        if (this.clazz.equals(WMSContext.class)) {
            throw new Exception("WMS CONTEXT ARE NOT SUPPORTED ANYMORE");
        }
        throw new Exception("Invalid class, generator not implemented, class was " + this.clazz.getClass());
    }

    public void destroy(T toDestroy) throws Exception {
        if (this.clazz.equals(FileSet.class)) {
            Generator.remove((FileSet)toDestroy);
        } else if (this.clazz.equals(Layer.class)) {
            Generator.remove((Layer)toDestroy);
        } else if (this.clazz.equals(WMSContext.class)) {
            Generator.remove((WMSContext)toDestroy);
        } else {
            throw new Exception("Invalid class, destroyer not implemented, class was " + toDestroy.getClass());
        }
    }

    public T update(T toUpdate) throws Exception {
        this.destroy(toUpdate);
        return this.generate();
    }

    protected static void remove(FileSet toDestroy) throws Exception {
        String physicalBasePath = publisher.getServerPathDir().getAbsolutePath();
        for (File f : toDestroy.getFiles()) {
            logger.debug("Deleting file " + f.getStoredUri() + " from FileSet " + toDestroy.getId());
            String path = String.valueOf(physicalBasePath) + java.io.File.separator + f.getStoredUri();
            try {
                ServiceUtils.deleteFile(path);
            }
            catch (Exception e) {
                logger.warn("Unable to delete " + path, (Throwable)e);
                throw e;
            }
        }
    }

    protected static void remove(Layer toDestroy) throws Exception {
        GISUtils.deleteLayer(toDestroy.getLayerInfo());
    }

    protected static void remove(WMSContext toDestroy) throws Exception {
        GISUtils.deleteWMSContext(toDestroy.getWmsContextInfo());
    }

    protected static Layer generateLayer(AquaMapsObjectData data, Submitted object) throws Exception {
        ArrayList<StyleGenerationRequest> toGenerateStyle = new ArrayList<StyleGenerationRequest>();
        ArrayList<String> toAssociateStyleList = new ArrayList<String>();
        if (object.getType().equals((Object)ObjectType.Biodiversity)) {
            toGenerateStyle.add(StyleGenerationRequest.getBiodiversityStyle(data.getMin(), data.getMax(), StyleGenerationRequest.ClusterScaleType.linear, object.getTitle()));
            toGenerateStyle.add(StyleGenerationRequest.getBiodiversityStyle(data.getMin(), data.getMax(), StyleGenerationRequest.ClusterScaleType.logarithmic, object.getTitle()));
        } else {
            toAssociateStyleList.add(StyleGenerationRequest.getDefaultDistributionStyle());
        }
        logger.debug("Loading metadata details for OBJ ID " + object.getSearchId());
        Map<String, Object> meta = AquaMapsManager.getMetaForGIS(object);
        ArrayList<String> imgUris = new ArrayList<String>();
        FileSet fs = (FileSet)ServiceContext.getContext().getPublisher().getById(FileSet.class, object.getFileSetId());
        String publisherHost = ServiceContext.getContext().getPublisher().getWebServerUrl();
        for (File f : fs.getFiles()) {
            imgUris.add(String.valueOf(publisherHost) + f.getStoredUri());
        }
        meta.put("META_FILESET_URIS", imgUris);
        meta.put("META_GEOMETRY_COUNT", new Integer(CSVUtils.countCSVRows((String)data.getCsvFile(), (char)',', (boolean)true).intValue()));
        HashMap keyMap = new HashMap();
        for (String s : CSVUtils.CSVToStringList((String)data.getSpeciesCSVList())) {
            Map<String, String> speciesNames = SpeciesManager.getSpeciesNamesById(s);
            for (Map.Entry<String, String> speciesName : speciesNames.entrySet()) {
                if (speciesName.getValue() == null) continue;
                if (!keyMap.containsKey(speciesName.getKey())) {
                    keyMap.put(speciesName.getKey(), new HashSet());
                }
                ((HashSet)keyMap.get(speciesName.getKey())).add(speciesName.getValue());
            }
        }
        HashSet<String> generalKeys = new HashSet<String>();
        generalKeys.add("AquaMaps");
        generalKeys.add("iMarine");
        generalKeys.add("Ecological niche modelling");
        generalKeys.add("" + object.getType());
        keyMap.put("General", generalKeys);
        meta.put("META_KEYWORDS_MAP", keyMap);
        boolean generated = false;
        int attemptCount = 0;
        int maxAttempt = ServiceContext.getContext().getPropertyAsInteger("GEOSERVER_MAX_ATTEMPT");
        LayerInfo layerInfo = null;
        String layerId = null;
        do {
            try {
                ++attemptCount;
                GISUtils.GISPublishedItem response = GISUtils.generateLayer(new LayerGenerationRequest(data.getCsvFile(), object.getType().equals((Object)ObjectType.Biodiversity) ? AquaMapsManager.maxSpeciesCountInACell : "" + HSPECFields.probability, object.getType().equals((Object)ObjectType.Biodiversity) ? "integer" : "real", object.getTitle(), object.getType().equals((Object)ObjectType.Biodiversity) ? LayerType.Biodiversity : LayerType.Prediction, toGenerateStyle, toAssociateStyleList, 0, meta));
                layerInfo = response.getLayerInfo();
                layerId = response.getMetaId();
                generated = true;
            }
            catch (Exception e) {
                if (attemptCount <= maxAttempt) {
                    long toWaitTimeMinutes = attemptCount * ServiceContext.getContext().getPropertyAsInteger("GEOSERVER_WAIT_FOR_RETRY_MINUTES");
                    logger.warn("Layer generation failed, this was attempt N " + attemptCount + ", going to retry in " + toWaitTimeMinutes + " minutes..");
                    try {
                        Thread.sleep(toWaitTimeMinutes * 60L * 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        } while (attemptCount <= maxAttempt && !generated);
        ArrayList speciesList = CSVUtils.CSVToStringList((String)data.getSpeciesCSVList());
        Resource source = SourceManager.getById(object.getSourceHSPEC());
        MetaInformations publisherMeta = new MetaInformations(object.getAuthor(), "", "", object.getTitle(), Long.valueOf(System.currentTimeMillis()), "" + source.getAlgorithm(), source.getGenerationTime());
        Layer toReturn = new Layer(layerInfo.getType(), object.getIsCustomized().booleanValue(), layerInfo, new CoverageDescriptor("" + object.getSourceHSPEC(), object.getSpeciesCoverage()), publisherMeta, new String[0]);
        toReturn.setSpeciesIds(speciesList.toArray(new String[speciesList.size()]));
        toReturn.setCustomized(object.getIsCustomized().booleanValue());
        toReturn.setId(layerId);
        return toReturn;
    }

    protected static FileSet generateFileSet(AquaMapsObjectData data, Submitted object) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (Map.Entry<String, String> toPublishEntry : FileSetUtils.generateFileMap(data.getCsq_str(), object.getTitle()).entrySet()) {
            files.add(new File(FileType.Image, toPublishEntry.getValue(), toPublishEntry.getKey()));
        }
        if (files.size() > 0) {
            logger.debug("Generated FileSet, passed base path " + data.getPath());
            ArrayList speciesList = CSVUtils.CSVToStringList((String)data.getSpeciesCSVList());
            Resource source = SourceManager.getById(object.getSourceHSPEC());
            MetaInformations meta = new MetaInformations(object.getAuthor(), "", "", object.getTitle(), Long.valueOf(System.currentTimeMillis()), "" + source.getAlgorithm(), source.getGenerationTime());
            FileSet toReturn = new FileSet(files, new CoverageDescriptor("" + object.getSourceHSPEC(), object.getSpeciesCoverage()), data.getPath(), meta);
            toReturn.setSpeciesIds(speciesList.toArray(new String[speciesList.size()]));
            toReturn.setCustomized(object.getIsCustomized().booleanValue());
            return toReturn;
        }
        throw new Exception("NO IMAGES WERE GENERATED FOR OBJECT " + object.getSearchId());
    }

    public static void cleanData(Submitted object) throws Exception {
        block14: {
            try (DBSession session = null;){
                session = DBSession.getInternalDBSession();
                ArrayList<Field> filter = new ArrayList<Field>();
                filter.add(new Field(GENERATION_ID, "" + object.getSearchId(), FieldType.INTEGER));
                ResultSet rs = session.executeFilteredQuery(filter, GENERATION_DATA_TABLE, GENERATION_ID, OrderDirection.ASC);
                if (rs.next()) {
                    logger.info("Deleting generation data for " + object.getSearchId());
                    try {
                        ServiceUtils.deleteFile(rs.getString(GENERATION_csq));
                    }
                    catch (Exception e) {
                        logger.warn("Unable to delete " + rs.getString(GENERATION_csq), (Throwable)e);
                    }
                    try {
                        ServiceUtils.deleteFile(rs.getString(GENERATION_csv));
                    }
                    catch (Exception e) {
                        logger.warn("Unable to delete " + rs.getString(GENERATION_csv), (Throwable)e);
                    }
                    for (String path : FileSetUtils.getTempFiles(object.getTitle())) {
                        try {
                            ServiceUtils.deleteFile(path);
                        }
                        catch (Exception e) {
                            logger.warn("Unable to delete " + path, (Throwable)e);
                        }
                    }
                    session.deleteOperation(GENERATION_DATA_TABLE, filter);
                    break block14;
                }
                logger.info("Unable to detect generation data for submitted " + object.getSearchId());
            }
        }
    }

    protected static AquaMapsObjectData getData(AquaMapsObjectExecutionRequest request) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(GENERATION_ID, "" + request.getObject().getSearchId(), FieldType.INTEGER));
            ResultSet rs = session.executeFilteredQuery(filter, GENERATION_DATA_TABLE, GENERATION_ID, OrderDirection.ASC);
            if (rs.next()) {
                AquaMapsObjectData aquaMapsObjectData = new AquaMapsObjectData(rs.getInt(GENERATION_ID), rs.getString(GENERATION_csq), rs.getInt(GENERATION_min), rs.getInt(GENERATION_max), rs.getString(GENERATION_csv), rs.getString(GENERATION_path), rs.getString(GENERATION_SPECIES));
                return aquaMapsObjectData;
            }
            session.close();
            AquaMapsObjectData toStore = null;
            if (request instanceof BiodiversityObjectExecutionRequest) {
                BiodiversityObjectExecutionRequest theRequest = (BiodiversityObjectExecutionRequest)request;
                toStore = Generator.getBiodiversityData(theRequest.getObject(), theRequest.getSelectedSpecies(), JobManager.getWorkingHSPEC(theRequest.getObject().getJobId()), theRequest.getThreshold());
            } else {
                DistributionObjectExecutionRequest theRequest = (DistributionObjectExecutionRequest)request;
                Species s = theRequest.getSelectedSpecies().iterator().next();
                toStore = Generator.getDistributionData(theRequest.getObject(), s.getId(), JobManager.getWorkingHSPEC(theRequest.getObject().getJobId()));
            }
            AquaMapsObjectData aquaMapsObjectData = Generator.storeData(toStore);
            return aquaMapsObjectData;
        }
    }

    private static AquaMapsObjectData storeData(AquaMapsObjectData toStore) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(GENERATION_ID, String.valueOf(toStore.getSubmittedId()), FieldType.INTEGER));
            row.add(new Field(GENERATION_csq, toStore.getCsq_str(), FieldType.STRING));
            row.add(new Field(GENERATION_csv, toStore.getCsvFile(), FieldType.STRING));
            row.add(new Field(GENERATION_max, String.valueOf(toStore.getMax()), FieldType.INTEGER));
            row.add(new Field(GENERATION_min, String.valueOf(toStore.getMin()), FieldType.INTEGER));
            row.add(new Field(GENERATION_path, String.valueOf(toStore.getPath()), FieldType.STRING));
            row.add(new Field(GENERATION_SPECIES, toStore.getSpeciesCSVList(), FieldType.STRING));
            rows.add(row);
            session.insertOperation(GENERATION_DATA_TABLE, rows);
            AquaMapsObjectData aquaMapsObjectData = toStore;
            return aquaMapsObjectData;
        }
    }

    private static AquaMapsObjectData getBiodiversityData(Submitted objectDescriptor, Set<Species> selectedSpecies, String hspecTable, float threshold) throws Exception {
        try (DBSession session = null;){
            logger.debug("DISTRIBUTION DATA FOR " + objectDescriptor.getSearchId() + ".... STARTED");
            session = DBSession.getInternalDBSession();
            String tableName = ServiceUtils.generateId("s", "");
            PreparedStatement prep = null;
            session.createTable(tableName, new String[]{SpeciesOccursumFields.speciesid + " varchar(50) PRIMARY KEY"});
            JobManager.addToDropTableList(objectDescriptor.getJobId(), tableName);
            ArrayList<List<Field>> toInsertSpecies = new ArrayList<List<Field>>();
            ArrayList<String> scientificNames = new ArrayList<String>();
            for (Species spec : selectedSpecies) {
                ArrayList<Field> row = new ArrayList<Field>();
                Species s = SpeciesManager.getSpeciesById(true, false, spec.getId(), 0);
                row.add(new Field("" + SpeciesOccursumFields.speciesid, s.getId(), FieldType.STRING));
                toInsertSpecies.add(row);
                String scientificName = s.getScientificName();
                scientificNames.add(scientificName);
            }
            session.insertOperation(tableName, toInsertSpecies);
            prep = session.preparedStatement(Generator.clusteringBiodiversityQuery(hspecTable, tableName));
            prep.setFloat(1, threshold);
            ResultSet rs = prep.executeQuery();
            if (rs.first()) {
                String path = String.valueOf(SpeciesManager.getCommonTaxonomy(selectedSpecies)) + java.io.File.separator + ServiceUtils.generateId(objectDescriptor.getTitle(), "");
                String clusterFile = FileSetUtils.createClusteringFile(objectDescriptor.getSearchId(), objectDescriptor.getJobId(), FileSetUtils.clusterize(rs, 2, 1, 2, true), objectDescriptor.getTitle());
                rs.first();
                Integer max = rs.getInt(AquaMapsManager.maxSpeciesCountInACell);
                rs.last();
                Integer min = rs.getInt(AquaMapsManager.maxSpeciesCountInACell);
                logger.info("Biodiversity query for object ID " + objectDescriptor.getSearchId() + " FOUND min : " + min + " max : " + max);
                String csvFile = ServiceContext.getContext().getPersistenceRoot() + java.io.File.separator + objectDescriptor.getJobId() + java.io.File.separator + objectDescriptor.getTitle() + ".csv";
                FileUtils.newFileUtils().createNewFile(new java.io.File(csvFile), true);
                CSVUtils.resultSetToCSVFile((ResultSet)rs, (String)csvFile, (boolean)false);
                Collections.sort(scientificNames);
                AquaMapsObjectData aquaMapsObjectData = new AquaMapsObjectData(objectDescriptor.getSearchId(), clusterFile, min, max, csvFile, path, CSVUtils.listToCSV(scientificNames));
                return aquaMapsObjectData;
            }
            return null;
        }
    }

    private static AquaMapsObjectData getDistributionData(Submitted objectDescriptor, String speciesId, String hspecTable) throws Exception {
        try (DBSession session = null;){
            logger.debug("DISTRIBUTION DATA FOR " + objectDescriptor.getSearchId() + ".... STARTED");
            session = DBSession.getInternalDBSession();
            String clusteringQuery = Generator.clusteringDistributionQuery(hspecTable);
            PreparedStatement ps = session.preparedStatement(clusteringQuery);
            ps.setString(1, speciesId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Species s = SpeciesManager.getSpeciesById(true, false, speciesId, 0);
                String path = objectDescriptor.getSourceHSPEC() + java.io.File.separator + s.getFieldbyName("" + SpeciesOccursumFields.kingdom).value() + java.io.File.separator + s.getFieldbyName("" + SpeciesOccursumFields.phylum).value() + java.io.File.separator + s.getFieldbyName("" + SpeciesOccursumFields.classcolumn).value() + java.io.File.separator + s.getFieldbyName("" + SpeciesOccursumFields.ordercolumn).value() + java.io.File.separator + s.getFieldbyName("" + SpeciesOccursumFields.familycolumn).value() + java.io.File.separator + s.getId() + (objectDescriptor.getIsCustomized() != false ? ServiceUtils.generateId(objectDescriptor.getAuthor(), "") : "");
                String scientificName = s.getScientificName();
                String clusterFile = FileSetUtils.createClusteringFile(objectDescriptor.getSearchId(), objectDescriptor.getJobId(), FileSetUtils.clusterize(rs, 2, 1, 2, false), objectDescriptor.getTitle());
                String csvFile = ServiceContext.getContext().getPersistenceRoot() + java.io.File.separator + objectDescriptor.getJobId() + java.io.File.separator + objectDescriptor.getTitle() + ".csv";
                FileUtils.newFileUtils().createNewFile(new java.io.File(csvFile), true);
                CSVUtils.resultSetToCSVFile((ResultSet)rs, (String)csvFile, (boolean)false);
                logger.debug("DISTRIBUTION DATA FOR " + objectDescriptor.getSearchId() + ".... COMPLETED");
                AquaMapsObjectData aquaMapsObjectData = new AquaMapsObjectData(objectDescriptor.getSearchId(), clusterFile, 0, 0, csvFile, path, scientificName);
                return aquaMapsObjectData;
            }
            return null;
        }
    }

    public static String clusteringDistributionQuery(String hspecName) {
        String query = "Select " + HCAF_SFields.csquarecode + ", " + HSPECFields.probability + "  FROM " + hspecName + " where " + hspecName + "." + SpeciesOccursumFields.speciesid + "=?  ORDER BY " + HSPECFields.probability + " DESC";
        logger.debug("clusteringDistributionQuery: " + query);
        return query;
    }

    private static String clusteringBiodiversityQuery(String hspecName, String tmpTable) {
        String query = "Select " + HCAF_SFields.csquarecode + ", count(k." + SpeciesOccursumFields.speciesid + ") AS " + AquaMapsManager.maxSpeciesCountInACell + " FROM " + hspecName + " as k Where  k." + SpeciesOccursumFields.speciesid + " in (select " + SpeciesOccursumFields.speciesid + " from " + tmpTable + " ) and " + HSPECFields.probability + " > ? GROUP BY " + HCAF_SFields.csquarecode + " order by " + AquaMapsManager.maxSpeciesCountInACell + " DESC";
        logger.debug("clusteringBiodiversityQuery: " + query);
        return query;
    }
}

