/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentalLogicManager {
    static final Logger logger = LoggerFactory.getLogger(EnvironmentalLogicManager.class);
    private static GenericObjectPool batchPool = new GenericObjectPool((PoolableObjectFactory)new BatchGeneratorObjectFactory(BatchGeneratorObjectFactory.BatchPoolType.LOCAL));
    private static GenericObjectPool remotePool = new GenericObjectPool((PoolableObjectFactory)new BatchGeneratorObjectFactory(BatchGeneratorObjectFactory.BatchPoolType.REMOTE));

    static {
        try {
            batchPool.setLifo(false);
            batchPool.setMaxActive(ServiceContext.getContext().getPropertyAsInteger("LOCAL_BATCH_POOL_SIZE").intValue());
            batchPool.setWhenExhaustedAction((byte)1);
            int i = 0;
            while (i < batchPool.getMaxActive()) {
                batchPool.addObject();
                ++i;
            }
            logger.debug("Added " + batchPool.getMaxActive() + " objects to local generator pool");
        }
        catch (Exception e) {
            logger.error("Unable to init batch pool", (Throwable)e);
        }
        try {
            remotePool.setLifo(false);
            remotePool.setMaxActive(ServiceContext.getContext().getPropertyAsInteger("REMOTE_BATCH_POOL_SIZE").intValue());
            remotePool.setWhenExhaustedAction((byte)1);
            int i = 0;
            while (i < remotePool.getMaxActive()) {
                remotePool.addObject();
                ++i;
            }
            logger.debug("Added " + remotePool.getMaxActive() + " objects to remote generator pool");
        }
        catch (Exception e) {
            logger.error("Unable to init remote pool", (Throwable)e);
        }
    }

    public static BatchGeneratorI getBatch(String submissionBackend) throws Exception {
        if (submissionBackend.equalsIgnoreCase(ServiceContext.getContext().getName())) {
            return (BatchGeneratorI)batchPool.borrowObject();
        }
        return (BatchGeneratorI)remotePool.borrowObject();
    }

    public static void leaveBatch(BatchGeneratorI theBatch) throws Exception {
        switch (theBatch.getType()) {
            case LOCAL: {
                batchPool.returnObject((Object)theBatch);
                break;
            }
            default: {
                remotePool.returnObject((Object)theBatch);
            }
        }
    }
}

