/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.client.species;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.constants.AquaMapsSpeciesViewConstants;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.DetailsParameter;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.fields.SpeciesFields;

public class SpeciesDetailsPanel
extends ContentPanel {
    private Image image = new Image();
    private EditorGrid<DetailsParameter> grid;
    private GroupingStore<DetailsParameter> store = new GroupingStore();

    public SpeciesDetailsPanel() {
        this.setFrame(true);
        this.setFrame(true);
        this.setSize(700, 450);
        this.setLayout((Layout)new FitLayout());
        this.image.setTitle("Fishbase picture");
        this.image.setAltText("");
        this.image.setSize("240", "240");
        ContentPanel gridPanel = new ContentPanel();
        gridPanel.setLayout((Layout)new FitLayout());
        gridPanel.setHeading("Meta Information");
        gridPanel.setCollapsible(true);
        this.store.groupBy(DetailsParameter.PARAMETER_GROUP);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig name = new ColumnConfig(DetailsParameter.PARAMETER_NAME, "Parameter", 100);
        columns.add(name);
        ColumnConfig value = new ColumnConfig(DetailsParameter.PARAMETER_VALUE, "Value", 100);
        columns.add(value);
        value.setEditor((CellEditor)new /* Unavailable Anonymous Inner Class!! */);
        ColumnModel cm = new ColumnModel(columns);
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        view.setAutoFill(true);
        view.setSortingEnabled(false);
        view.setStartCollapsed(true);
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.grid = new EditorGrid((ListStore)this.store, cm);
        this.grid.addListener(Events.AfterEdit, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.grid.addListener(Events.BeforeEdit, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.grid.setHideHeaders(true);
        this.grid.setView((GridView)view);
        this.grid.setBorders(true);
        this.grid.setHeight(300);
        this.grid.setWidth(340);
        this.grid.setStripeRows(true);
        gridPanel.add((Widget)this.grid);
        this.add((Widget)this.image);
        this.add((Component)gridPanel);
        this.setHeading("Species Details");
        this.setScrollMode(Style.Scroll.AUTOY);
    }

    public void setSpeciesData(ModelData data) {
        this.mask("Loading details..");
        String scientificName = data.get(SpeciesFields.genus + "").toString() + " " + data.get(SpeciesFields.species + "").toString();
        this.setHeading(scientificName + " details.");
        this.image.setUrl(data.get("PATH").toString());
        this.image.setAltText("Fish Base image for " + scientificName);
        this.image.setTitle(scientificName + " from FishBase");
        this.image.setPixelSize(240, 240);
        ArrayList<DetailsParameter> toAdd = new ArrayList<DetailsParameter>();
        for (SpeciesFields f : AquaMapsSpeciesViewConstants.nameSpeciesFields) {
            try {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), data.get(f + "").toString(), "Species Names"));
            }
            catch (Throwable t) {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), "N/A", "Species Names"));
            }
        }
        for (SpeciesFields f : AquaMapsSpeciesViewConstants.taxonomySpeciesFields) {
            try {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), data.get(f + "").toString(), "Species Taxonomy"));
            }
            catch (Throwable t) {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), "N/A", "Species Taxonomy"));
            }
        }
        for (SpeciesFields f : AquaMapsSpeciesViewConstants.characteristicsSpeciesFields) {
            try {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), Integer.parseInt((String)data.get(f + "")) == 1 ? "true" : "false", "Species Characteristics"));
            }
            catch (Throwable t) {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), "N/A", "Species Characteristics"));
            }
        }
        for (SpeciesFields f : AquaMapsSpeciesViewConstants.codesSpeciesFields) {
            try {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), data.get(f + "").toString(), "Species Codes"));
            }
            catch (Throwable t) {
                toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.speciesFieldsNames.get(f), "N/A", "Species Codes"));
            }
        }
        this.store.removeAll();
        this.store.add(toAdd);
        this.unmask();
        Log.debug((String)("store contains : " + this.store.getModels().size()));
    }
}

