/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.utils.Utils;
import org.gcube.application.framework.core.session.ASLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapServlet
extends HttpServlet {
    private static final long serialVersionUID = 5433023032821426866L;
    private static final Logger logger = LoggerFactory.getLogger(MapServlet.class);
    private static final ArrayList<Field> basicFilters = new ArrayList();
    private static final Submitted submittedModel = new Submitted(Integer.valueOf(0));

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.trace("SpeciesServlet-handleRequest");
        try {
            ASLSession session = Utils.getSession((HttpSession)request.getSession());
            StringBuilder sb = new StringBuilder();
            int startIndex = 0;
            int limit = 100;
            try {
                startIndex = Integer.parseInt(request.getParameter("start"));
                limit = Integer.parseInt(request.getParameter("limit"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String sortColumn = request.getParameter("sort");
            String sortDir = request.getParameter("dir");
            if (sortColumn == null) {
                sortColumn = SubmittedFields.searchid + "";
            }
            if (sortDir == null) {
                sortDir = "ASC";
            }
            try {
                PagedRequestSettings settings = new PagedRequestSettings(limit, startIndex, sortColumn, OrderDirection.valueOf((String)sortDir));
                response.getWriter().write(DBManager.getInstance((String)session.getScope()).getMaps(session.getUsername(), settings));
                response.setContentType("application/json; charset=utf-8");
                response.getWriter().write(sb.toString());
                response.setStatus(200);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace("Error from server", (Throwable)e);
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(401);
        }
    }

    static {
        submittedModel.setStatus(SubmittedStatus.Completed);
        submittedModel.setIsAquaMap(Boolean.valueOf(true));
        submittedModel.setToDelete(Boolean.valueOf(false));
        basicFilters.add(submittedModel.getField(SubmittedFields.status));
        basicFilters.add(submittedModel.getField(SubmittedFields.isaquamap));
        basicFilters.add(submittedModel.getField(SubmittedFields.todelete));
    }
}

