/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.tests.model;

import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.bson.types.ObjectId;
import org.gcube.application.geoportal.common.model.legacy.AbstractRelazione;
import org.gcube.application.geoportal.common.model.legacy.AccessPolicy;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.UploadedImage;

public class TestModel {
    public static File getBaseFolder() {
        File toReturn = new File("../test-data/concessioni");
        if (!toReturn.exists()) {
            toReturn = new File("test-data/concessioni");
        }
        if (!toReturn.exists()) {
            throw new RuntimeException("Unable to find test data");
        }
        return toReturn;
    }

    public static Concessione prepareEmptyConcessione() {
        Concessione concessione = new Concessione();
        concessione.setNome("MONGO Italia, forse, ma su ");
        concessione.setIntroduzione("This is my MONGO project");
        concessione.setDescrizioneContenuto("It contains this and that");
        concessione.setAuthors(Arrays.asList("Some one", "Some, oneelse"));
        concessione.setContributore("Contrib 1");
        concessione.setTitolari(Arrays.asList("Some one", "Some, oneelse"));
        concessione.setResponsabile("Someone");
        concessione.setEditore("Editore");
        concessione.setFontiFinanziamento(Arrays.asList("Big pharma", "Pentagon"));
        concessione.setSoggetto(Arrays.asList("Research Excavation", "Archeology"));
        concessione.setDataInizioProgetto(LocalDateTime.now());
        concessione.setDataFineProgetto(LocalDateTime.now());
        concessione.setLicenzaID("CC-BY");
        concessione.setTitolareLicenza(Arrays.asList("Qualcun altro"));
        concessione.setTitolareCopyright(Arrays.asList("Chiedilo in giro"));
        concessione.setParoleChiaveLibere(Arrays.asList("Robba", "Stuff"));
        concessione.setParoleChiaveICCD(Arrays.asList("vattelapesca", "somthing something"));
        return concessione;
    }

    public static final Concessione setIds(Concessione c) {
        c.getRelazioneScavo().setMongo_id(TestModel.rnd());
        c.getPosizionamentoScavo().setMongo_id(TestModel.rnd());
        c.getPianteFineScavo().forEach(l -> l.setMongo_id(TestModel.rnd()));
        c.getImmaginiRappresentative().forEach(i -> i.setMongo_id(TestModel.rnd()));
        return c;
    }

    public static final String rnd() {
        return new ObjectId().toHexString();
    }

    public static Concessione prepareConcessione() {
        return TestModel.prepareConcessione(4, 2);
    }

    public static Concessione prepareConcessione(int pianteCount, int imgsCount) {
        Concessione concessione = TestModel.prepareEmptyConcessione();
        RelazioneScavo relScavo = new RelazioneScavo();
        relScavo.setResponsabili(concessione.getAuthors());
        concessione.setRelazioneScavo(relScavo);
        AbstractRelazione abstractRelazione = new AbstractRelazione();
        abstractRelazione.setAbstractIta("Il mio abstract");
        abstractRelazione.setAbstractEng("My abstract");
        concessione.setAbstractRelazione(abstractRelazione);
        ArrayList<UploadedImage> imgs = new ArrayList<UploadedImage>();
        for (int i = 0; i < imgsCount; ++i) {
            UploadedImage img = new UploadedImage();
            img.setTitolo("My image number " + i);
            img.setDidascalia("You can see my image number " + i);
            img.setFormat("TIFF");
            img.setCreationTime(LocalDateTime.now());
            img.setResponsabili(concessione.getAuthors());
            imgs.add(img);
        }
        concessione.setImmaginiRappresentative(imgs);
        LayerConcessione posizionamento = new LayerConcessione();
        posizionamento.setValutazioneQualita("Secondo me si");
        posizionamento.setMetodoRaccoltaDati("Fattobbene");
        posizionamento.setScalaAcquisizione("1:10000");
        posizionamento.setAuthors(concessione.getAuthors());
        concessione.setPosizionamentoScavo(posizionamento);
        ArrayList<LayerConcessione> piante = new ArrayList<LayerConcessione>();
        for (int i = 0; i < pianteCount; ++i) {
            LayerConcessione pianta = new LayerConcessione();
            pianta.setValutazioneQualita("Secondo me si");
            pianta.setMetodoRaccoltaDati("Fattobbene");
            pianta.setScalaAcquisizione("1:10000");
            pianta.setAuthors(concessione.getAuthors());
            pianta.setPolicy(AccessPolicy.RESTRICTED);
            piante.add(pianta);
        }
        concessione.setPianteFineScavo(piante);
        return concessione;
    }
}

