package org.gcube.application.cms.tests;

import ch.qos.logback.core.net.SyslogOutputStream;
import org.gcube.application.cms.plugins.InitializablePlugin;
import org.gcube.application.cms.plugins.Plugin;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

import java.rmi.ServerError;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;

public class BasicPluginTest {

    static List<Plugin> plugins;

    @BeforeClass
    public static void checkPluginRegistration() {


        Reflections reflections = new Reflections(
                new ConfigurationBuilder()
                        .forPackage("org.gcube.application.cms")
                        .filterInputsBy(new FilterBuilder().includePackage("org.gcube.application.cms")));

        reflections.getSubTypesOf(Plugin.class).iterator().forEachRemaining(pluginClass->{
            if(!pluginClass.isInterface()){
                try {
                    Plugin plugin = pluginClass.newInstance();
                    plugins.add(plugin);
                }catch (Throwable t){
                    t.printStackTrace(System.err);
                    Assert.fail("Unable to Load "+pluginClass);
                }
            }

        });


        Assert.assertFalse(plugins.isEmpty());
        System.out.println("Plugin Loading OK");
    }


    @Test
    public void basicChecks(){
        plugins.forEach(p->{
            System.out.println("INIT Plugin "+p.getClass());
            Assert.assertNotNull(p.getDescriptor());
            Assert.assertNotNull(p.getDescriptor().getId());
            Assert.assertNotNull(p.getDescriptor().getType());
            Assert.assertNotNull(p.getDescriptor().getVersion());
            if(p instanceof InitializablePlugin){
                InitializablePlugin ip=(InitializablePlugin)p;
                try {
                    ip.init();
                } catch (InitializationException e) {
                    e.printStackTrace(System.err);
                    Assert.fail("Unable to Init "+p.getDescriptor().getId());
                }
            }
        });
    }
}
