/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.tests.plugins;

import java.util.Map;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.Plugin;
import org.gcube.application.cms.plugins.faults.EventException;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.InvalidProfileException;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.StepExecutionReport;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.cms.tests.TokenSetter;
import org.gcube.application.cms.tests.plugins.BasicPluginTest;
import org.gcube.application.geoportal.common.model.plugins.LifecycleManagerDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.utils.tests.GCubeTest;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLCPluginTest
extends BasicPluginTest {
    private static final Logger log = LoggerFactory.getLogger(BasicLCPluginTest.class);

    @Test
    public void testLifeCycle() {
        for (Map.Entry entry : plugins.entrySet()) {
            String s = (String)entry.getKey();
            Plugin p = (Plugin)entry.getValue();
            if (!p.getDescriptor().getType().equals("LifecycleManagement")) continue;
            System.out.println("Testing LC Manager " + p.getDescriptor());
            LifecycleManager ip = (LifecycleManager)p;
            try {
                EventExecutionReport rep;
                EventExecutionRequest req;
                LifecycleManagerDescriptor descriptor = (LifecycleManagerDescriptor)p.getDescriptor();
                log.info("EVENTS ARE {}", (Object)descriptor.getSupportedEvents());
                for (Map.Entry e : descriptor.getSupportedEvents().entrySet()) {
                    req = this.prepareEventRequest((String)e.getKey());
                    log.info("Launching request {} ", (Object)req);
                    rep = this.testEvent(ip, req);
                    log.info("Report is {} ", (Object)rep);
                }
                if (descriptor.getSupportedSteps() != null) {
                    log.info("STEPS ARE {}", (Object)descriptor.getSupportedEvents());
                    for (Map.Entry e : descriptor.getSupportedSteps().entrySet()) {
                        req = this.prepareStepRequest((String)e.getKey());
                        log.info("Launching request {} ", (Object)req);
                        rep = this.testStep(ip, (StepExecutionRequest)req);
                        log.info("Report is {} ", (Object)rep);
                    }
                }
                ip.init().validate();
                if (!GCubeTest.isTestInfrastructureEnabled()) continue;
                TokenSetter.set(GCubeTest.getContext());
                ip.initInContext().validate();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                Assert.fail((String)("Unable to Init " + p.getDescriptor().getId()));
            }
        }
    }

    protected StepExecutionRequest prepareStepRequest(String stepId) {
        return new StepExecutionRequest(this.getUCD(), this.getCurrentUser(), this.getContextObject(), this.getBasicProject(), stepId);
    }

    protected EventExecutionRequest prepareEventRequest(String event) {
        return new EventExecutionRequest(this.getUCD(), this.getCurrentUser(), this.getContextObject(), this.getBasicProject(), event);
    }

    protected EventExecutionReport testEvent(LifecycleManager lc, EventExecutionRequest r) throws InvalidPluginRequestException, EventException {
        return lc.onEvent(r);
    }

    protected StepExecutionReport testStep(LifecycleManager lc, StepExecutionRequest r) throws InvalidPluginRequestException, StepException, InvalidProfileException, StepException, ConfigurationException, InsufficientPrivileges {
        return lc.performStep(r);
    }
}

