package org.gcube.application.cms.concessioni.plugins;

import lombok.extern.slf4j.Slf4j;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.model.PluginDescriptor;
import org.gcube.application.cms.plugins.reports.ExecutionReport;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.document.ComparableVersion;

@Slf4j
public class ConcessioniLifeCycleManager implements LifecycleManager {

    private static final PluginDescriptor DESCRIPTOR=new PluginDescriptor("GNA-CONCESSIONI-LC", PluginDescriptor.BaseTypes.LIFECYCLE_MANAGER);
    static {
        DESCRIPTOR.setDescription("GNA Concessioni. This plugin supports custom lifecycle management for the GNA Concessioni UseCase.");
        DESCRIPTOR.setVersion(new ComparableVersion("1.0.0"));
    }


    @Override
    public InitializationReport initInContext() throws InitializationException {
        return null;
    }

    @Override
    public InitializationReport init() throws InitializationException {
        return null;
    }

    @Override
    public void shutdown() throws ShutDownException {

    }

    @Override
    public ExecutionReport performStep(StepExecutionRequest request) throws StepException {
        log.info("Received Request ");

        switch(request.getStep()){
            case StepExecutionRequest.Steps.ON_INIT_DOCUMENT:{
                break;
            }
            case StepExecutionRequest.Steps.ON_MATERIALIZE_DOCUMENT:{
                break;
            }
            case StepExecutionRequest.Steps.ON_DEMATERIALIZE_DOCUMENT:{
                break;
            }
            case StepExecutionRequest.Steps.ON_DEINDEX_DOCUMENT:{
                break;
            }
            case StepExecutionRequest.Steps.ON_INDEX_DOCUMENT:{
                break;
            }
            case StepExecutionRequest.Steps.ON_DELETE_DOCUMENT:{
                break;
            }
            default : throw new StepException("Invalid Step "+request.getStep());
        }
        throw new StepException("Still to implement");
    }

    @Override
    public PluginDescriptor getDescriptor() {
        return DESCRIPTOR;
    }
}
