package org.gcube.application.cms.concessioni.plugins;

import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.gcube.application.cms.custom.gna.concessioni.model.ProfiledConcessione;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.model.PluginDescriptor;
import org.gcube.application.cms.plugins.reports.ExecutionReport;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.document.ComparableVersion;
import org.gcube.application.geoportal.common.model.document.ProfiledDocument;
import org.gcube.application.geoportal.common.utils.JSONPathWrapper;

@Slf4j
public class ConcessioniLifeCycleManager implements LifecycleManager {

    private static final PluginDescriptor DESCRIPTOR=new PluginDescriptor("GNA-CONCESSIONI-LC", PluginDescriptor.BaseTypes.LIFECYCLE_MANAGER);
    static {
        DESCRIPTOR.setDescription("GNA Concessioni. This plugin supports custom lifecycle management for the GNA Concessioni UseCase.");
        DESCRIPTOR.setVersion(new ComparableVersion("1.0.0"));
    }


    @Override
    public InitializationReport initInContext() throws InitializationException {
        return null;
    }

    @Override
    public InitializationReport init() throws InitializationException {
        return null;
    }

    @Override
    public void shutdown() throws ShutDownException {

    }

    @Override
    public ExecutionReport performStep(StepExecutionRequest request) throws StepException {
        log.info("Serving Request {}",request);
        ExecutionReport report=new ExecutionReport();
        report.setRequest(request);
        report.setStatus(Report.Status.OK);
        try {
            switch (request.getStep()) {
                case StepExecutionRequest.Steps.ON_INIT_DOCUMENT:
                    // Set Defaults as for on update
                case StepExecutionRequest.Steps.ON_UPDATE_DOCUMENT: {
                    ProfiledDocument doc = request.getDocument();

                    break;
                }
                case StepExecutionRequest.Steps.ON_MATERIALIZE_DOCUMENT: {
                    break;
                }
                case StepExecutionRequest.Steps.ON_DEMATERIALIZE_DOCUMENT: {
                    break;
                }
                case StepExecutionRequest.Steps.ON_DEINDEX_DOCUMENT: {
                    break;
                }
                case StepExecutionRequest.Steps.ON_INDEX_DOCUMENT: {
                    break;
                }
                case StepExecutionRequest.Steps.ON_DELETE_DOCUMENT: {
                    break;
                }
                default:
                    throw new StepException("Invalid Step " + request.getStep());
            }
        }catch (StepException e){
            throw e;
        }catch (Throwable t){
            log.error("Unable to perform step "+request.getStep(),t);
            report.setStatus(Report.Status.ERROR);
            report.getMessages().add("Unable to execute Step "+request.getStep()+". Error was "+t.getMessage());
        }
        return report;
    }

    @Override
    public PluginDescriptor getDescriptor() {
        return DESCRIPTOR;
    }


    // STATIC ROUTINES

    private static final ProfiledDocument setDefaults(ProfiledDocument document){
        ProfiledConcessione c =(ProfiledConcessione) document;
        c.setDefaults();
        return c;
    }


}
