/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.concessioni.plugins;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.custom.gna.concessioni.model.ProfiledConcessione;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.implementations.ProjectAccess;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.IndexingException;
import org.gcube.application.cms.plugins.implementations.Default3PhaseManager;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.IndexDocumentRequest;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.relationships.Relationship;
import org.gcube.application.geoportal.common.model.document.relationships.RelationshipNavigationObject;
import org.gcube.application.geoportal.common.model.legacy.report.ConstraintCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioniLifeCycleManager
extends Default3PhaseManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(ConcessioniLifeCycleManager.class);
    private static final String FOLLOWS = "follows";
    private static final String PRECEDES = "precedes";

    public ConcessioniLifeCycleManager() {
        this.DESCRIPTOR.setId("GNA-CONCESSIONI-LC");
        this.DESCRIPTOR.setDescription("GNA Concessioni. This plugin supports custom lifecycle management for the GNA Concessioni UseCase.");
        this.DESCRIPTOR.setVersion(new Semver("1.0.0"));
    }

    public EventExecutionReport setDefault(EventExecutionReport currentReport) {
        EventExecutionReport report = super.setDefault(currentReport);
        try {
            report.setResultingDocument(ConcessioniLifeCycleManager.setDefaults(((EventExecutionRequest)report.getTheRequest()).getDocument()).getTheDocument());
        }
        catch (Throwable t) {
            log.error("Unable to evaluate defaults for concessione " + ((EventExecutionRequest)currentReport.getTheRequest()).getDocument().getId(), t);
            log.debug("Object was {} ", (Object)((EventExecutionRequest)report.getTheRequest()).getDocument());
            report.setStatus(Report.Status.ERROR);
            report.getMessages().add("Unable to evaluate defaults : " + t.getMessage());
        }
        return report;
    }

    static final Project setDefaults(Project document) throws IOException {
        int i;
        log.info("Concessione ID {}, setting defaults..", (Object)document.getId());
        log.debug("Full concessione is {}", (Object)document);
        ProfiledConcessione c = (ProfiledConcessione)Serialization.convert((Object)document, ProfiledConcessione.class);
        Document doc = c.getTheDocument();
        doc.putIfAbsent((Object)"soggetto", (Object)new String[]{"Research Excavation", "Archaeology"});
        doc.putIfAbsent((Object)"descrizioneContenuto", (Object)"Relazione di fine scavo e relativo abstract; selezione di immagini rappresentative; posizionamento topografico dell'area indagata, pianta di fine scavo.");
        c.getInfo().getAccess().setLicense((String)ConstraintCheck.defaultFor((Object)c.getInfo().getAccess().getLicense(), (Object)"CC0-1.0").evaluate());
        Document rel = doc.containsKey((Object)"relazioneScavo") ? (Document)Serialization.convert((Object)doc.get((Object)"relazioneScavo"), Document.class) : new Document();
        log.debug("Concessione {}, managing relazione {}", (Object)document.getId(), (Object)rel);
        rel.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " relazione di scavo"));
        rel.putIfAbsent((Object)"soggetto", doc.get((Object)"soggetto"));
        doc.put("relazioneScavo", (Object)rel);
        Document abs = doc.containsKey((Object)"abstractRelazione") ? (Document)Serialization.convert((Object)doc.get((Object)"abstractRelazione"), Document.class) : new Document();
        log.debug("Concessione {}, managing abstract relazione {}", (Object)document.getId(), (Object)abs);
        abs.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " abstract relazione di scavo"));
        doc.put("abstractRelazione", (Object)abs);
        if (doc.containsKey((Object)"posizionamentoScavo")) {
            Document pos = (Document)Serialization.convert((Object)doc.get((Object)"posizionamentoScavo"), Document.class);
            log.debug("Concessione {}, managing posizionamento scavo {}", (Object)document.getId(), (Object)pos);
            pos.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " posizionamento scavo"));
            pos.putIfAbsent((Object)"abstractSection", (Object)"Posizionamento topografico georeferenziato dell\u2019area interessata dalle indagini");
            pos.putIfAbsent((Object)"topicCategory", (Object)"Society");
            pos.putIfAbsent((Object)"subTopic", (Object)"Archeology");
            pos.putIfAbsent((Object)"paroleChiaveLibere", doc.get((Object)"paroleChiaveLibere"));
            pos.putIfAbsent((Object)"paroleChiaveICCD", doc.get((Object)"paroleChiaveICCD"));
            pos.put("responsabile", doc.get((Object)"responsabile"));
            doc.put("posizionamentoScavo", (Object)pos);
        }
        JSONPathWrapper wrapper = new JSONPathWrapper(Serialization.write((Object)doc));
        if (doc.containsKey((Object)"immaginiRappresentative")) {
            List imgs = (List)wrapper.getByPath("$.immaginiRappresentative", List.class).get(0);
            log.debug("Concessione {}, found imgs {}", (Object)document.getId(), (Object)imgs.size());
            for (i = 0; i < imgs.size(); ++i) {
                Document imgDoc = Serialization.asDocument(imgs.get(i));
                imgDoc.putIfAbsent((Object)"soggetto", doc.get((Object)"soggetto"));
                wrapper.setElement("$.immaginiRappresentative[" + i + "]", (Object)imgDoc);
            }
        }
        if (doc.containsKey((Object)"pianteFineScavo")) {
            List piante = (List)wrapper.getByPath("$.pianteFineScavo", List.class).get(0);
            log.debug("Concessione {}, found piante {}", (Object)document.getId(), (Object)piante.size());
            for (i = 0; i < piante.size(); ++i) {
                Document piantaDoc = Serialization.asDocument(piante.get(i));
                log.debug("Concessione {}, managing pianta {}", (Object)document.getId(), (Object)piantaDoc);
                piantaDoc.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " pianta fine scavo"));
                piantaDoc.putIfAbsent((Object)"abstractSection", (Object)"Planimetria georeferenziata dell'area indagata al termine delle attivit\u00e0");
                piantaDoc.putIfAbsent((Object)"topicCategory", (Object)"Society");
                piantaDoc.putIfAbsent((Object)"subTopic", (Object)"Archeology");
                piantaDoc.putIfAbsent((Object)"paroleChiaveLibere", doc.get((Object)"paroleChiaveLibere"));
                piantaDoc.putIfAbsent((Object)"paroleChiaveICCD", doc.get((Object)"paroleChiaveICCD"));
                piantaDoc.put("responsabile", doc.get((Object)"responsabile"));
                wrapper.setElement("$.pianteFineScavo[" + i + "]", (Object)piantaDoc);
            }
        }
        c.setTheDocument((Document)Serialization.read((String)wrapper.getValueCTX().jsonString(), Document.class));
        return c;
    }

    protected Document evaluateAdditionalIndexParameters(IndexDocumentRequest request) throws IndexingException {
        Document toReturn = super.evaluateAdditionalIndexParameters(request);
        if (toReturn == null) {
            toReturn = new Document();
        }
        Project indexingProject = request.getDocument();
        log.info("Evaluating relationship chain. Current ID is {}", (Object)indexingProject.getId());
        try {
            ArrayList<Project> projects = new ArrayList<Project>();
            ProjectAccess access = (ProjectAccess)ImplementationProvider.get().getProvidedObjectByClass(ProjectAccess.class);
            projects.add(indexingProject);
            if (!indexingProject.getRelationshipsByName(PRECEDES).isEmpty()) {
                ConcessioniLifeCycleManager.scanRelation(projects, (RelationshipNavigationObject)access.getRelations(indexingProject.getProfileID(), indexingProject.getId(), PRECEDES, Boolean.valueOf(true)).get(0), false);
            }
            if (!indexingProject.getRelationshipsByName(FOLLOWS).isEmpty()) {
                ConcessioniLifeCycleManager.scanRelation(projects, (RelationshipNavigationObject)access.getRelations(indexingProject.getProfileID(), indexingProject.getId(), FOLLOWS, Boolean.valueOf(true)).get(0), false);
            }
            log.debug("Produced full chain [size : {}] from {}, evaluating last available for PHASE {} ", new Object[]{projects.size(), indexingProject.getId(), indexingProject.getLifecycleInformation().getPhase()});
            log.info("projects are: " + projects.size());
            ArrayList<String> toDisplayId = new ArrayList<String>();
            ArrayList<String> toHideIds = new ArrayList<String>();
            Collections.sort(projects, Collections.reverseOrder(new ProjectRelationComparator()));
            if (log.isInfoEnabled()) {
                int j = 0;
                log.info("Printing project reverse order....");
                for (Project theProject : projects) {
                    log.info(++j + ") " + theProject.getId() + " data inizio: " + theProject.getTheDocument().get((Object)"dataInizioProgetto"));
                }
            }
            log.trace("Checking from LAST.. ");
            for (int i = 0; i < projects.size(); ++i) {
                Project p = (Project)projects.get(i);
                String phase = p.getLifecycleInformation().getPhase();
                if (toDisplayId.isEmpty()) {
                    if (phase.equals("Pending Approval") || phase.equals("Published")) {
                        toDisplayId.add(p.getId());
                        continue;
                    }
                    if (p.getId().compareTo(indexingProject.getId()) != 0) continue;
                    toDisplayId.add(p.getId());
                    continue;
                }
                toHideIds.add(p.getId());
            }
            toReturn.put("_toHideIds", toHideIds);
            toReturn.put("_toDisplayIds", toDisplayId);
            log.info("Indexing request for " + indexingProject.getProfileID() + " [ID {}] with to _toHideIds {} and _toDisplayIds {} ", new Object[]{indexingProject.getId(), toHideIds, toDisplayId});
            return toReturn;
        }
        catch (Exception e) {
            log.error("Unable to evaluate to Hide and Display Ids ", (Throwable)e);
            throw new IndexingException("Unable to evaluate chain ids to hide / display", (Throwable)e);
        }
    }

    private static void scanRelation(ArrayList chain, RelationshipNavigationObject obj, boolean putBefore) {
        if (putBefore) {
            chain.add(0, obj.getTarget());
        } else {
            chain.add(obj.getTarget());
        }
        if (obj.getChildren() != null) {
            obj.getChildren().forEach(r -> ConcessioniLifeCycleManager.scanRelation(chain, r, putBefore));
        }
    }

    public static Integer compareProjectAgainstRelations(Project source, Project target) {
        log.debug("comparing source {} and target {}", (Object)source.getId(), (Object)target.getId());
        List listRel = source.getRelationships();
        log.debug("relationships of {} are : {}", (Object)source.getId(), (Object)listRel);
        if (listRel != null) {
            String targetId = target.getId();
            for (Relationship relationship : listRel) {
                String relTargetId = relationship.getTargetID();
                if (targetId.compareTo(relTargetId) != 0) continue;
                String relationName = relationship.getRelationshipName();
                if (relationName.equals(PRECEDES)) {
                    log.debug("source {} [rel {} ] target {}, so source < target ", new Object[]{source.getId(), PRECEDES, target.getId()});
                    return -1;
                }
                if (!relationName.equals(FOLLOWS)) continue;
                log.debug("source {} [rel {} ] target {}, so source > target ", new Object[]{source.getId(), FOLLOWS, target.getId()});
                return 1;
            }
        }
        log.debug("No relations beetween a & b");
        return null;
    }

    public static class ProjectRelationComparator
    implements Comparator<Project> {
        @Override
        public int compare(Project p1, Project p2) {
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            Integer compareResult = null;
            compareResult = ConcessioniLifeCycleManager.compareProjectAgainstRelations(p1, p2);
            log.trace("p1 & p2, comparator result: {}", (Object)compareResult);
            if (compareResult == null) {
                log.debug("No relations beetween p1 & p2, checking inverted relations");
                compareResult = ConcessioniLifeCycleManager.compareProjectAgainstRelations(p2, p1);
                log.trace("p2 & p1, comparator result: {}", (Object)compareResult);
                if (compareResult == null) {
                    log.trace("p1 & p2, are not comparable, returning 0");
                    compareResult = 0;
                }
            }
            log.debug("p1 & p2, comparator result, returns: {}", (Object)compareResult);
            return compareResult;
        }
    }
}

