/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.gcube.application.cms.implementations.utils.UserUtils;
import org.gcube.application.cms.notifications.NotificationEventsSubscribedConfig;
import org.gcube.application.cms.notifications.config.SubscribeNotificationEvent;
import org.gcube.application.cms.notifications.manage.ManageDoActionNotification;
import org.gcube.application.cms.notifications.substitutor.NMessagesPlaceholdersSubstitutorUtil;
import org.gcube.application.cms.plugins.EventListenerPluginInterface;
import org.gcube.application.cms.plugins.events.EventListener;
import org.gcube.application.cms.plugins.events.EventManager;
import org.gcube.application.cms.plugins.events.ItemObserved;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.MaterializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.implementations.AbstractPlugin;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.plugins.PluginDescriptor;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsPlugin
extends AbstractPlugin
implements EventListenerPluginInterface {
    private static final Logger log = LoggerFactory.getLogger(NotificationsPlugin.class);
    private final Object $lock = new Object[0];
    public static final String SUBSCRIBE_NOTIFICATIONS_CONFIG = "subscribeNotifications";
    public static final String PLUGIN_ID = "Notifications-Plugin";
    public static final String PLUGIN_TYPE = "EventListener";
    public static final PluginDescriptor DESCRIPTOR = new PluginDescriptor("Notifications-Plugin", "EventListener");
    protected Map<String, Map<String, NotificationEventsSubscribedConfig>> notificationEventsBindingMap = null;

    public InitializationReport init() throws InitializationException {
        log.debug("Called init");
        InitializationReport report = null;
        try {
            EventListener<ItemObserved<Project>> listenerCreated = new EventListener<ItemObserved<Project>>(){

                public void updated(ItemObserved<Project> observerd) {
                    log.info("listenerCreated fired on item: {} ", observerd);
                    boolean subscribed = NotificationsPlugin.this.checkIfSubscribedEvent(observerd);
                    if (subscribed) {
                        NotificationsPlugin.this.doAction(observerd);
                    }
                }
            };
            EventListener<ItemObserved<Project>> listenerUpdated = new EventListener<ItemObserved<Project>>(){

                public void updated(ItemObserved<Project> observerd) {
                    log.info("listenerUpdated fired on item: {} ", observerd);
                    boolean subscribed = NotificationsPlugin.this.checkIfSubscribedEvent(observerd);
                    if (subscribed) {
                        NotificationsPlugin.this.doAction(observerd);
                    }
                }
            };
            EventListener<ItemObserved<Project>> listenerDeleted = new EventListener<ItemObserved<Project>>(){

                public void updated(ItemObserved<Project> observerd) {
                    log.info("listenerDeleted fired on item: {} ", observerd);
                    boolean subscribed = NotificationsPlugin.this.checkIfSubscribedEvent(observerd);
                    if (subscribed) {
                        NotificationsPlugin.this.doAction(observerd);
                    }
                }
            };
            EventListener<ItemObserved<Project>> listenerLCStepPerformed = new EventListener<ItemObserved<Project>>(){

                public void updated(ItemObserved<Project> observerd) {
                    log.info("listenerLCStepPerformed fired on item: {} ", observerd);
                    boolean subscribed = NotificationsPlugin.this.checkIfSubscribedEvent(observerd);
                    if (subscribed) {
                        NotificationsPlugin.this.doAction(observerd);
                    }
                }
            };
            EventManager eventMngInst = EventManager.getInstance();
            eventMngInst.subscribe(EventManager.Event.PROJECT_CREATED, (EventListener)listenerCreated);
            eventMngInst.subscribe(EventManager.Event.PROJECT_UPDATED, (EventListener)listenerUpdated);
            eventMngInst.subscribe(EventManager.Event.PROJECT_DELETED, (EventListener)listenerDeleted);
            eventMngInst.subscribe(EventManager.Event.LIFECYCLE_STEP_PERFORMED, (EventListener)listenerLCStepPerformed);
            report = new InitializationReport(Report.Status.OK, new String[]{"Notifications-Plugin init performed"});
        }
        catch (Exception e) {
            InitializationException exc = new InitializationException("Unable to initialize " + DESCRIPTOR.getId(), (Throwable)e);
            log.error("init error: {} ", (Throwable)exc);
            throw exc;
        }
        return report;
    }

    public PluginDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitializationReport initInContext() throws InitializationException {
        Object object = this.$lock;
        synchronized (object) {
            InitializationReport report = new InitializationReport();
            try {
                String context = UserUtils.getCurrent().getContext();
                if (this.getNotificationBindingMapPerContext() == null) {
                    log.info("Initializing in " + context);
                    this.notificationEventsBindingMap.put(context, new HashMap());
                }
                report.setStatus(Report.Status.OK);
                report.putMessage("Initialized " + DESCRIPTOR.getId() + " in the " + context);
            }
            catch (Exception e) {
                InitializationException exc = new InitializationException("Unable to initialize " + DESCRIPTOR.getId(), (Throwable)e);
                log.error("initInContext error: {} ", (Throwable)exc);
                throw exc;
            }
            return report;
        }
    }

    public boolean checkIfSubscribedEvent(ItemObserved<Project> observerd) {
        log.info("Checking if {} is an subscribed event", (Object)observerd.getEvent());
        try {
            NotificationEventsSubscribedConfig eventsSub = this.readNotificationsSubscribedFromConfigurationInTheUCD(observerd.getUseCaseDescriptor());
            if (eventsSub != null) {
                List<SubscribeNotificationEvent> listEvents = eventsSub.getListNotificationEventSubscribed();
                log.info("List events is {}", listEvents);
                if (listEvents != null && listEvents.stream().anyMatch(sne -> sne.getEvent().equals((Object)observerd.getEvent()))) {
                    log.info("the event {} is subscribed from config ", (Object)observerd.getEvent());
                    return true;
                }
                log.info("the event {} is not subscribed from config ", (Object)observerd.getEvent());
                return false;
            }
            log.info("the event {} is not subscribed from config ", (Object)observerd.getEvent());
            return false;
        }
        catch (Exception e) {
            log.error("Exception, Error on checking subscribed events", (Throwable)e);
            return false;
        }
    }

    protected Map<String, NotificationEventsSubscribedConfig> getNotificationBindingMapPerContext() {
        LinkedHashMap map;
        String context = UserUtils.getCurrent().getContext();
        log.debug("Getting {} from cache map for context {}", (Object)PLUGIN_ID, (Object)context);
        if (this.notificationEventsBindingMap == null) {
            this.notificationEventsBindingMap = new LinkedHashMap<String, Map<String, NotificationEventsSubscribedConfig>>();
        }
        return (map = this.notificationEventsBindingMap.get(context)) == null ? new LinkedHashMap() : map;
    }

    private void setNotificationBindingMapPerContext(String context, UseCaseDescriptor ucd, NotificationEventsSubscribedConfig notification) {
        Map<String, NotificationEventsSubscribedConfig> mapNotificationConfig = this.notificationEventsBindingMap.get(context);
        if (mapNotificationConfig == null) {
            mapNotificationConfig = new LinkedHashMap<String, NotificationEventsSubscribedConfig>();
        }
        mapNotificationConfig.put(ucd.getId(), notification);
        this.notificationEventsBindingMap.put(context, mapNotificationConfig);
    }

    public NotificationEventsSubscribedConfig readNotificationsSubscribedFromConfigurationInTheUCD(UseCaseDescriptor useCaseDescriptor) throws Exception {
        NotificationEventsSubscribedConfig notificationMapPerContext;
        block10: {
            log.debug("Reading subscribed events from UCD");
            notificationMapPerContext = null;
            if (useCaseDescriptor == null) {
                throw new Exception("Error reading UCD null found");
            }
            try {
                List<SubscribeNotificationEvent> listNotificationEventsSubscribedPerUCD;
                String context = UserUtils.getCurrent().getContext();
                Map<String, NotificationEventsSubscribedConfig> mapPerContext = this.getNotificationBindingMapPerContext();
                notificationMapPerContext = mapPerContext.get(useCaseDescriptor.getId());
                if (notificationMapPerContext == null) {
                    notificationMapPerContext = new NotificationEventsSubscribedConfig();
                    this.setNotificationBindingMapPerContext(context, useCaseDescriptor, notificationMapPerContext);
                }
                if ((listNotificationEventsSubscribedPerUCD = notificationMapPerContext.getListNotificationEventSubscribed()) != null) break block10;
                listNotificationEventsSubscribedPerUCD = new ArrayList<SubscribeNotificationEvent>();
                Document profileConfiguration = this.getConfigurationFromProfile(useCaseDescriptor).getConfiguration();
                log.debug("UseCaseDescriptor Configuration is {} ", (Object)profileConfiguration);
                if (profileConfiguration != null) {
                    for (Object fsConfigObj : (List)profileConfiguration.get((Object)SUBSCRIBE_NOTIFICATIONS_CONFIG, List.class)) {
                        log.debug("Managing {}\u00a0", fsConfigObj);
                        SubscribeNotificationEvent fsConfig = (SubscribeNotificationEvent)Serialization.convert(fsConfigObj, SubscribeNotificationEvent.class);
                        log.debug("Converted config {}", (Object)fsConfig);
                        try {
                            EventManager.Event theEventSubsribed = (EventManager.Event)Serialization.convert((Object)fsConfig.getEvent(), EventManager.Event.class);
                            if (theEventSubsribed == null) {
                                throw new MaterializationException("Invalid Field Definition path in configuration [NO MATCH]  : " + theEventSubsribed);
                            }
                        }
                        catch (Exception e) {
                            log.error("MaterializationException: ", (Throwable)e);
                            throw new MaterializationException("Invalid Event Definition path in configuration [NO MATCH Event] : " + EventManager.Event.values());
                        }
                        listNotificationEventsSubscribedPerUCD.add(fsConfig);
                    }
                    notificationMapPerContext.setUcd(useCaseDescriptor);
                    notificationMapPerContext.setListNotificationEventSubscribed(listNotificationEventsSubscribedPerUCD);
                    String linkToMessages = (String)profileConfiguration.get((Object)"link_to_notifications_messages", String.class);
                    notificationMapPerContext.setLinkToNotificationsMessages(linkToMessages);
                }
                this.setNotificationBindingMapPerContext(context, useCaseDescriptor, notificationMapPerContext);
                log.info("Events subscribed read from config {} ", (Object)notificationMapPerContext);
            }
            catch (Exception e) {
                log.error("Unable to read configuration for Notifications-Plugin", (Throwable)e);
            }
            catch (Throwable t) {
                log.error("Exception, Unable to read configuration ", t);
            }
        }
        return notificationMapPerContext;
    }

    public void shutdown() throws ShutDownException {
    }

    public void doAction(ItemObserved<Project> itemObserved) {
        log.debug("doAction called...");
        boolean isSubscribedEvent = this.checkIfSubscribedEvent(itemObserved);
        log.info("Is the event {} subscribed in notification plugin configured in the UCD: {} ", (Object)itemObserved.getEvent(), (Object)isSubscribedEvent);
        if (isSubscribedEvent) {
            Map<String, NotificationEventsSubscribedConfig> notificationMapPerContext = this.getNotificationBindingMapPerContext();
            NotificationEventsSubscribedConfig subscribedConfig = notificationMapPerContext.get(itemObserved.getUCD_Id());
            String linkToFileWithMessages = subscribedConfig.getLinkToNotificationsMessages();
            List<SubscribeNotificationEvent> list = subscribedConfig.getListNotificationEventSubscribed();
            List<SubscribeNotificationEvent> filterList = list.stream().filter(sne -> sne.getEvent().equals((Object)itemObserved.getEvent())).collect(Collectors.toList());
            log.debug(linkToFileWithMessages);
            NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil = null;
            try {
                nMPlaceholdersSUtil = new NMessagesPlaceholdersSubstitutorUtil(linkToFileWithMessages);
            }
            catch (IOException e) {
                log.error("Error instancing the {}. Please check the URL {}. Returning!!", (Object)NMessagesPlaceholdersSubstitutorUtil.class.getSimpleName(), (Object)linkToFileWithMessages);
                return;
            }
            ManageDoActionNotification mdoact = new ManageDoActionNotification(itemObserved, nMPlaceholdersSUtil, filterList);
            mdoact.manage();
        }
    }

    static {
        DESCRIPTOR.setVersion(new Semver("1.0.0"));
        DESCRIPTOR.setDescription("Manage the notification from Geoportal engine");
    }
}

