/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.manage;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gcube.application.cms.notifications.config.NotificationWhen;
import org.gcube.application.cms.notifications.config.Notify;
import org.gcube.application.cms.notifications.config.serviceaccount.GeoportalServiceAccount;
import org.gcube.application.cms.notifications.social.SocialClients;
import org.gcube.application.cms.notifications.substitutor.NMessagesPlaceholdersSubstitutorUtil;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.portal.databook.shared.Post;
import org.gcube.social_networking.social_networking_client_library.NotificationClient;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEvent;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyUsers {
    private static final Logger log = LoggerFactory.getLogger(NotifyUsers.class);
    private List<User> recipientUsers;
    private NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil;
    private List<NotificationWhen> listNotificationWhen;
    private SocialClients socialClients;
    private CatalogueEventType catalogueEventType;

    public NotifyUsers(SocialClients socialClients, List<NotificationWhen> listWhen, NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil, List<User> recipientUsers, CatalogueEventType catalogueEventType) {
        this.socialClients = socialClients;
        this.listNotificationWhen = listWhen;
        this.recipientUsers = recipientUsers;
        this.nMPlaceholdersSUtil = nMPlaceholdersSUtil;
        this.catalogueEventType = catalogueEventType;
    }

    public void sendNotification() throws Exception {
        log.info("send notification...");
        List<Notify> listNotifies = this.toNotify();
        for (Notify notify : listNotifies) {
            switch (notify.getType()) {
                case USER_POST: {
                    log.info("Notification type {}, send: {}", (Object)notify.getType(), (Object)notify.getSend());
                    if (!notify.getSend().booleanValue()) break;
                    log.debug("Building message...");
                    String subject = "Message";
                    String body = null;
                    subject = this.nMPlaceholdersSUtil.replacePlaceholder(notify.getPlaceholder_title());
                    body = this.nMPlaceholdersSUtil.replacePlaceholder(notify.getPlaceholder_msg());
                    log.debug("subject: {}", (Object)subject);
                    log.debug("body: {}", (Object)body);
                    log.info("Sending message to users: {}", this.recipientUsers);
                    this.postMessage(subject, body, this.catalogueEventType);
                    break;
                }
                case VRE_POST: {
                    if (!notify.getSend().booleanValue()) break;
                    log.info("Notification type {}, send: {}", (Object)notify.getType(), (Object)notify.getSend());
                    PostInputBean toWrite = null;
                    Post thePost = this.socialClients.writeUserPost(toWrite);
                    log.info("{} post created: {} ", (Object)notify.getType(), (Object)thePost);
                    break;
                }
                case EMAIL: {
                    break;
                }
            }
        }
    }

    private List<Notify> toNotify() {
        ArrayList<Notify> listNotifies = new ArrayList<Notify>();
        for (NotificationWhen notificationWhen : this.listNotificationWhen) {
            listNotifies.addAll(notificationWhen.getNotify().stream().filter(n -> n.getSend() == true).collect(Collectors.toList()));
        }
        return listNotifies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postMessage(String subject, String bodyMessage, CatalogueEventType catalogueEventType) throws Exception {
        CatalogueEvent catalogueEvent = this.getCatalogueEvent(subject, bodyMessage);
        SecretManager secretManager = SecretManagerProvider.instance.get();
        try {
            Secret geoportalSecret = GeoportalServiceAccount.getGeoportalSecret();
            secretManager.startSession(geoportalSecret);
            this.sendNotification(catalogueEvent);
        }
        catch (Exception e) {
            log.error("Error while sending notification", (Throwable)e);
        }
        finally {
            if (secretManager != null) {
                secretManager.endSession();
            }
        }
    }

    protected void sendNotification(final CatalogueEvent catalogueEvent) throws Exception {
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        log.debug("{} is going to send the following notification {}", (Object)SecretManagerProvider.instance.get().getUser().getUsername(), (Object)catalogueEvent);
                        NotificationClient nc = NotifyUsers.this.socialClients.getNotificationClient();
                        nc.sendCatalogueEvent(catalogueEvent);
                    }
                    catch (Exception e) {
                        log.error("Error while sending notification from thread", (Throwable)e);
                    }
                }
            };
            thread.start();
        }
        catch (Exception e) {
            log.error("Error while sending notification", (Throwable)e);
        }
    }

    protected CatalogueEvent getCatalogueEvent(String subject, String bodyMessage) throws Exception {
        CatalogueEvent catalogueEvent = new CatalogueEvent();
        catalogueEvent.setType(this.catalogueEventType);
        catalogueEvent.setNotifyText(bodyMessage);
        catalogueEvent.setItemId(subject);
        String itemURL = this.nMPlaceholdersSUtil.getPlaceholderMapValues().getGisLink();
        if (itemURL != null) {
            catalogueEvent.setItemURL(new URL(itemURL));
        }
        String[] usersToNotify = (String[])this.recipientUsers.stream().map(u -> u.getUsername()).toArray(String[]::new);
        catalogueEvent.setIdsToNotify(usersToNotify);
        catalogueEvent.setIdsAsGroup(false);
        return catalogueEvent;
    }

    protected CatalogueEvent toCatalogueEvent(CatalogueEventType catalogueEventType, String messageString, String subject, String itemURL, List<String> users) throws Exception {
        CatalogueEvent catalogueEvent = new CatalogueEvent();
        catalogueEvent.setType(catalogueEventType);
        catalogueEvent.setNotifyText(messageString);
        catalogueEvent.setItemId(subject);
        if (itemURL != null) {
            catalogueEvent.setItemURL(new URL(itemURL));
        }
        catalogueEvent.setIdsToNotify(users.toArray(new String[users.size()]));
        catalogueEvent.setIdsAsGroup(false);
        return catalogueEvent;
    }
}

