/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.manage;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gcube.application.cms.notifications.config.ExportAsPDF;
import org.gcube.application.cms.notifications.config.NotificationWhen;
import org.gcube.application.cms.notifications.config.Notify;
import org.gcube.application.cms.notifications.social.SocialClients;
import org.gcube.application.cms.notifications.substitutor.NMessagesPlaceholdersSubstitutorUtil;
import org.gcube.application.cms.plugins.events.ItemObserved;
import org.gcube.application.cms.serviceaccount.GeoportalServiceAccount;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portlets.user.uriresolvermanager.geoportal.GeoportalExporterAPI;
import org.gcube.social_networking.social_networking_client_library.NotificationClient;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEvent;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyToSocial {
    private static final Logger log = LoggerFactory.getLogger(NotifyToSocial.class);
    private List<User> recipientUsers;
    private NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil;
    private List<NotificationWhen> listNotificationWhen;
    private SocialClients socialClients = new SocialClients();
    private CatalogueEventType catalogueEventType;
    private ItemObserved<Project> itemObserved;

    public NotifyToSocial(ItemObserved<Project> itemObserved, List<NotificationWhen> listWhen, NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil, List<User> recipientUsers, CatalogueEventType catalogueEventType) {
        this.itemObserved = itemObserved;
        this.listNotificationWhen = listWhen;
        this.recipientUsers = recipientUsers;
        this.nMPlaceholdersSUtil = nMPlaceholdersSUtil;
        this.catalogueEventType = catalogueEventType;
    }

    public void sendNotification() throws Exception {
        log.info("send notification...");
        List<Notify> listNotifies = this.toNotify();
        log.info("listNotifies are {} ", listNotifies);
        for (Notify notify : listNotifies) {
            switch (notify.getType()) {
                case USER_NOTIFICATION: {
                    String optionalMessage;
                    log.info("Notification type {}, send: {}", (Object)notify.getType(), (Object)notify.getSend());
                    if (!notify.getSend().booleanValue()) break;
                    log.debug("Building Notification...");
                    String subject = "Notification";
                    String body = null;
                    subject = this.nMPlaceholdersSUtil.replacePlaceholder(this.itemObserved, notify.getPlaceholder_title());
                    body = this.nMPlaceholdersSUtil.replacePlaceholder(this.itemObserved, notify.getPlaceholder_msg());
                    ExportAsPDF exportAsPDF = notify.getExport_as_pdf();
                    String pdfRequest = this.getPDFLinkRequest(exportAsPDF);
                    if (pdfRequest != null) {
                        String pdfReportMsg = this.nMPlaceholdersSUtil.replacePlaceholder(this.itemObserved, exportAsPDF.getPlaceholder_msg());
                        body = body + "\n" + pdfReportMsg;
                    }
                    if ((optionalMessage = this.itemObserved.getOptionalValue(ItemObserved.OPTIONAL_FIELD.message)) != null) {
                        body = body + "\n" + optionalMessage;
                    }
                    log.info("Going to send notification to users: {}", this.recipientUsers);
                    log.info("subject: {}", (Object)subject);
                    log.info("body: {}", (Object)body);
                    this.userNotify(subject, body, this.catalogueEventType);
                    break;
                }
                case VRE_POST: {
                    String optionalMessage;
                    ExportAsPDF exportAsPDF;
                    String pdfRequest;
                    log.info("Notification type {}, send: {}", (Object)notify.getType(), (Object)notify.getSend());
                    if (!notify.getSend().booleanValue()) break;
                    PostInputBean toWrite = new PostInputBean();
                    String title = this.nMPlaceholdersSUtil.replacePlaceholder(this.itemObserved, notify.getPlaceholder_title());
                    String body = this.nMPlaceholdersSUtil.replacePlaceholder(this.itemObserved, notify.getPlaceholder_msg());
                    if (title != null) {
                        toWrite.setPreviewtitle(title);
                    }
                    if ((pdfRequest = this.getPDFLinkRequest(exportAsPDF = notify.getExport_as_pdf())) != null) {
                        String pdfReportMsg = this.nMPlaceholdersSUtil.replacePlaceholder(this.itemObserved, exportAsPDF.getPlaceholder_msg());
                        body = body + "\n" + pdfReportMsg;
                    }
                    if ((optionalMessage = this.itemObserved.getOptionalValue(ItemObserved.OPTIONAL_FIELD.message)) != null) {
                        body = body + "\n" + optionalMessage;
                    }
                    toWrite.setText(body);
                    String previewURL = this.itemObserved.getOptionalValue(ItemObserved.OPTIONAL_FIELD.preview_url);
                    System.out.println("previewURL: " + previewURL);
                    if (previewURL != null) {
                        toWrite.setPreviewurl(previewURL);
                    }
                    this.vrePost(toWrite, notify);
                    break;
                }
                case EMAIL: {
                    break;
                }
            }
        }
    }

    private String getPDFLinkRequest(ExportAsPDF exportAsPDF) {
        try {
            if (exportAsPDF != null && exportAsPDF.getExport().booleanValue()) {
                GeoportalExporterAPI geoportalExporterAPI = new GeoportalExporterAPI();
                String thePDFShortLink = geoportalExporterAPI.exportProject("pdf", this.itemObserved.getUCD_Id(), this.itemObserved.getProjectId(), false, true);
                this.nMPlaceholdersSUtil.getPlaceholderMapValues().putProjectAsPDFLink(thePDFShortLink);
                return thePDFShortLink;
            }
        }
        catch (Exception e) {
            log.error("Error while getting PDFLinkRequest", (Throwable)e);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vrePost(PostInputBean toWrite, Notify notify) {
        SecretManager secretManager = SecretManagerProvider.instance.get();
        try {
            Secret geoportalSecret = GeoportalServiceAccount.getGeoportalSecret();
            secretManager.startSession(geoportalSecret);
            log.debug("{} is going to send vrePost {}", (Object)SecretManagerProvider.instance.get().getUser().getUsername(), (Object)toWrite);
            String bodyWithTag = toWrite.getText() + "\n#" + geoportalSecret.getUser().getUsername();
            log.debug("body with tag: {}", (Object)bodyWithTag);
            toWrite.setText(bodyWithTag);
            toWrite.setEnablenotification(true);
            log.info("Calling social - going to write application post: {}", (Object)toWrite);
            Post thePost = this.socialClients.writeApplication(toWrite);
            log.info("{} post created: {} ", (Object)notify.getType(), (Object)thePost);
        }
        catch (Exception e) {
            log.error("Error while sending vrePost", (Throwable)e);
        }
        finally {
            if (secretManager != null) {
                try {
                    secretManager.endSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void userNotify(String subject, String bodyMessage, CatalogueEventType catalogueEventType) throws Exception {
        CatalogueEvent catalogueEvent = this.getCatalogueEvent(subject, bodyMessage);
        SecretManager secretManager = SecretManagerProvider.instance.get();
        try {
            Secret secret = GeoportalServiceAccount.getGeoportalSecret();
            secretManager.startSession(secret);
            NotificationClient nc = this.socialClients.getNotificationClient();
            log.info("Calling social - {} is going to send the notification {}", (Object)SecretManagerProvider.instance.get().getUser().getUsername(), (Object)catalogueEvent);
            nc.sendCatalogueEvent(catalogueEvent);
        }
        catch (Exception e) {
            log.error("Error while sending notification", (Throwable)e);
        }
        finally {
            if (secretManager != null) {
                try {
                    secretManager.endSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<Notify> toNotify() {
        ArrayList<Notify> listNotifies = new ArrayList<Notify>();
        for (NotificationWhen notificationWhen : this.listNotificationWhen) {
            listNotifies.addAll(notificationWhen.getNotify().stream().filter(n -> n.getSend() == true).collect(Collectors.toList()));
        }
        return listNotifies;
    }

    protected CatalogueEvent getCatalogueEvent(String subject, String bodyMessage) throws Exception {
        CatalogueEvent catalogueEvent = new CatalogueEvent();
        catalogueEvent.setType(this.catalogueEventType);
        catalogueEvent.setNotifyText(bodyMessage);
        catalogueEvent.setItemId(subject);
        String itemURL = this.nMPlaceholdersSUtil.getPlaceholderMapValues().getFirstApplicationLink();
        if (itemURL != null) {
            catalogueEvent.setItemURL(new URL(itemURL));
        }
        String[] usersToNotify = (String[])this.recipientUsers.stream().map(u -> u.getUsername()).toArray(String[]::new);
        catalogueEvent.setIdsToNotify(usersToNotify);
        catalogueEvent.setIdsAsGroup(false);
        return catalogueEvent;
    }

    protected CatalogueEvent toCatalogueEvent(CatalogueEventType catalogueEventType, String messageString, String subject, String itemURL, List<String> users) throws Exception {
        CatalogueEvent catalogueEvent = new CatalogueEvent();
        catalogueEvent.setType(catalogueEventType);
        catalogueEvent.setNotifyText(messageString);
        catalogueEvent.setItemId(subject);
        if (itemURL != null) {
            catalogueEvent.setItemURL(new URL(itemURL));
        }
        catalogueEvent.setIdsToNotify(users.toArray(new String[users.size()]));
        catalogueEvent.setIdsAsGroup(false);
        return catalogueEvent;
    }
}

