/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.manage;

import org.gcube.application.cms.notifications.gis.GisClient;
import org.gcube.application.cms.notifications.substitutor.SubstitutorPlaceholdersMap;
import org.gcube.application.cms.plugins.events.ItemObserved;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.portlets.user.uriresolvermanager.resolvers.query.GeoportalResolverQueryStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveProjectLinkFromPlaceholder {
    private static final Logger log = LoggerFactory.getLogger(ResolveProjectLinkFromPlaceholder.class);

    public static SubstitutorPlaceholdersMap resolveLink(ItemObserved<Project> itemObserved, SubstitutorPlaceholdersMap map, String placeholderMessage) {
        log.debug("resolveLink called for map {} and placeholderMessage {}", (Object)map, (Object)placeholderMessage);
        if (placeholderMessage == null || placeholderMessage.isEmpty()) {
            return map;
        }
        if (placeholderMessage.contains("private_data_entry_link") && map.get("private_data_entry_link") == null) {
            String link = GisClient.gisLink(GeoportalResolverQueryStringBuilder.RESOLVE_AS.PRIVATE, itemObserved.getUCD_Id(), itemObserved.getProjectId(), itemObserved.getContext().getId(), GeoportalResolverQueryStringBuilder.TARGET_GEOPORTAL_APP.GEO_DE, true);
            map.putPrivateDataEntryLink(link);
            return map;
        }
        if (placeholderMessage.contains("public_data_entry_link") && map.get("public_data_entry_link") == null) {
            String link = GisClient.gisLink(GeoportalResolverQueryStringBuilder.RESOLVE_AS.PUBLIC, itemObserved.getUCD_Id(), itemObserved.getProjectId(), itemObserved.getContext().getId(), GeoportalResolverQueryStringBuilder.TARGET_GEOPORTAL_APP.GEO_DE, true);
            map.putPublicDataEntryLink(link);
            return map;
        }
        if (placeholderMessage.contains("private_data_viewer_link") && map.get("private_data_viewer_link") == null) {
            String link = GisClient.gisLink(GeoportalResolverQueryStringBuilder.RESOLVE_AS.PRIVATE, itemObserved.getUCD_Id(), itemObserved.getProjectId(), itemObserved.getContext().getId(), GeoportalResolverQueryStringBuilder.TARGET_GEOPORTAL_APP.GEO_DV, true);
            map.putPrivateDataViewerLink(link);
            return map;
        }
        if (placeholderMessage.contains("public_data_viewer_link") && map.get("public_data_viewer_link") == null) {
            String link = GisClient.gisLink(GeoportalResolverQueryStringBuilder.RESOLVE_AS.PUBLIC, itemObserved.getUCD_Id(), itemObserved.getProjectId(), itemObserved.getContext().getId(), GeoportalResolverQueryStringBuilder.TARGET_GEOPORTAL_APP.GEO_DV, true);
            map.putPublicDataViewerLink(link);
            return map;
        }
        return map;
    }
}

