/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.plugins;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.cms.implementations.ISInterface;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.plugins.InitializablePlugin;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.implementations.AbstractPlugin;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.sdi.engine.PostgisIndexer;
import org.gcube.application.cms.sdi.engine.SDIManagerWrapper;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SDIAbstractPlugin
extends AbstractPlugin
implements InitializablePlugin {
    private static final Logger log = LoggerFactory.getLogger(SDIAbstractPlugin.class);
    private static final Object $LOCK = new Object[0];
    public static final String POSTGIS_CREDENTIALS = "POSTGIS-CREDENTIALS";
    public static final String SDI_CACHE = "SDI-CACHE";
    protected static AbstractScopedMap<SDIManagerWrapper> sdiCache;
    protected static AbstractScopedMap<DatabaseConnection> postgisCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCache() {
        Object object = $LOCK;
        synchronized (object) {
            if (sdiCache == null) {
                log.info("Creating internal caches.. ");
                sdiCache = new AbstractScopedMap<SDIManagerWrapper>(SDI_CACHE){

                    protected SDIManagerWrapper retrieveObject(String context) throws ConfigurationException {
                        try {
                            return new SDIManagerWrapper();
                        }
                        catch (Exception e) {
                            throw new ConfigurationException((Throwable)e);
                        }
                    }
                };
                sdiCache.setTTL((TemporalAmount)Duration.of(10L, ChronoUnit.MINUTES));
            }
            if (postgisCache == null) {
                postgisCache = new AbstractScopedMap<DatabaseConnection>(POSTGIS_CREDENTIALS){

                    protected DatabaseConnection retrieveObject(String context) throws ConfigurationException {
                        try {
                            DatabaseConnection db = ((ISInterface)ImplementationProvider.get().getProvidedObjectByClass(ISInterface.class)).queryForDatabase("Database", "postgis", "GNA_DB", "Concessioni");
                            log.debug("Postgis Connection in {} is {} ", (Object)context, (Object)db);
                            return db;
                        }
                        catch (Exception e) {
                            throw new ConfigurationException((Throwable)e);
                        }
                    }
                };
                postgisCache.setTTL((TemporalAmount)Duration.of(10L, ChronoUnit.MINUTES));
            }
        }
    }

    public InitializationReport init() throws InitializationException {
        InitializationReport report = new InitializationReport();
        try {
            SDIAbstractPlugin.initCache();
            PostgisIndexer.init();
            report.setStatus(Report.Status.OK);
        }
        catch (Throwable e) {
            throw new InitializationException("SDI Plugins : Unable to initialize Internal Caches ", e);
        }
        return report;
    }

    public void shutdown() throws ShutDownException {
    }
}

