package org.gcube.application.enm.client.plugins;

import org.gcube.application.enm.client.Constants;
import org.gcube.application.enm.client.proxies.Manager;
import org.gcube.application.enm.stubs.ManagerPortType;
import org.gcube.common.clients.gcore.builders.StatelessBuilder;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.common.clients.gcore.plugins.Plugin;


public abstract class AbstractPlugin<S,P> implements Plugin<S,P> {

	private static final ManagerPlugin manager_plugin = new ManagerPlugin();
	
	
	public static StatelessBuilder<Manager> manager() {
		return new StatelessBuilderImpl<ManagerPortType,Manager>(manager_plugin);
	}
		
	public final String name;
	
	public AbstractPlugin(String name) {
		this.name=name;
	}
	
	@Override
	public String serviceClass() {
		return Constants.SERVICE_CLASS;
	}
	
	@Override
	public String serviceName() {
		return Constants.SERVICE_NAME;
	}
	
	@Override
	public String namespace() {
		return Constants.NAMESPACE;
	}
	
	@Override
	public String name() {
		return name;
	}
	
}