package org.gcube.application.enm.client.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.enm.client.proxies.DefaultManager;
import org.gcube.application.enm.client.proxies.Manager;
import org.gcube.application.enm.stubs.ManagerPortType;
import org.gcube.application.enm.stubs.service.ManagerServiceAddressingLocator;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.utils.logging.GCUBELog;

public class ManagerPlugin extends AbstractPlugin<ManagerPortType, Manager> {

	GCUBELog logger = new GCUBELog(ManagerPlugin.class);
	
	public ManagerPlugin() {
		super("gcube/data/speciesproductsdiscovery/manager");
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> proxy) {
		return fault;
	}

	@Override
	public Manager newProxy(ProxyDelegate<ManagerPortType> proxy) {
		return new DefaultManager(proxy);
	}

	@Override
	public ManagerPortType resolve(EndpointReferenceType address,ProxyConfig<?,?> config) throws Exception {
		return new ManagerServiceAddressingLocator().getManagerPortTypePort(address);
	}

}
