package org.gcube.application.enm.client.proxies;

import java.rmi.RemoteException;
import org.gcube.application.enm.common.xml.bindings.Bindings;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.stubs.ManagerPortType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.types.VOID;

import static org.gcube.common.clients.exceptions.FaultDSL.*;

public class DefaultManager implements Manager {

	private final ProxyDelegate<ManagerPortType> delegate;
	
	
	public DefaultManager(ProxyDelegate<ManagerPortType> config){
		this.delegate = config;
	}


	@Override
	public String sumbitExperiment(final ExperimentRequest request)
			throws RemoteException {
		Call<ManagerPortType, String> call = new Call<ManagerPortType, String>() {
			@Override
			public String call(ManagerPortType managerPT) throws Exception {
				return managerPT.sumbitExperiment(Bindings.toXml(request));
			}
		};
		
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
		
	}


	@Override
	public ExperimentStatus getStatus(final String experimentId)
			throws RemoteException {
		Call<ManagerPortType, ExperimentStatus> call = new Call<ManagerPortType, ExperimentStatus>() {
			@Override
			public ExperimentStatus call(ManagerPortType managerPT) throws Exception {
				String result = managerPT.getStatus(experimentId);
				return (ExperimentStatus)Bindings.fromXml(result);
			}
		};
		
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}


	@Override
	public ExperimentResults getResults(final String experimentId)
			throws RemoteException {
		Call<ManagerPortType, ExperimentResults> call = new Call<ManagerPortType, ExperimentResults>() {
			@Override
			public ExperimentResults call(ManagerPortType managerPT) throws Exception {
				String result = managerPT.getStatus(experimentId);
				return (ExperimentResults)Bindings.fromXml(result);
			}
		};
		
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}


	@Override
	public ExperimentLogs getLogs(final String experimentId) throws RemoteException {
		Call<ManagerPortType, ExperimentLogs> call = new Call<ManagerPortType, ExperimentLogs>() {
			@Override
			public ExperimentLogs call(ManagerPortType managerPT) throws Exception {
				String result = managerPT.getStatus(experimentId);
				return (ExperimentLogs)Bindings.fromXml(result);
			}
		};
		
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}


	@Override
	public void cancelExperiment(final String experimentId) throws RemoteException {
		Call<ManagerPortType, VOID> call = new Call<ManagerPortType, VOID>() {
			@Override
			public VOID call(ManagerPortType managerPT) throws Exception {
				return managerPT.cancelExperiment(experimentId);
			}
		};
		
		try {
			delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
		
	}
		
		
}
