package org.gcube.application.enm.service.concurrent;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;

import org.gcube.application.enm.common.xml.status.StatusType;
import org.gcube.application.enm.service.GenericJob;

/**
 * @deprecated As release 1.0, replaced by {@link JobMonitor}.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
@Deprecated public class JobMonitorBlocking {

	/**
	 * The list of jobs waiting for execution, ordered by their priority.
	 */
	private final BlockingQueue<FIFOEntry<GenericJob>> pendingJobs = 
			new PriorityBlockingQueue<FIFOEntry<GenericJob>>();

	/**
	 * The list of all jobs.
	 */
	private ConcurrentMap<UUID, GenericJob> jobsMap = null;

	/**
	 * The singleton instance of the monitor.
	 */
	private static JobMonitorBlocking instance;

	/**
	 * Get the singleton instance of the monitor.
	 * @return The singleton instance.
	 */
	public static JobMonitorBlocking get() {
		if (instance == null) {
			instance = new JobMonitorBlocking();
		}
		// return instance;
		return null;
	}

	public synchronized void init(
			final ConcurrentMap<UUID, GenericJob> jobsMap) 
					throws IllegalArgumentException {
		if (this.jobsMap == null) {
			this.jobsMap = jobsMap;
			if (this.jobsMap != null) {
				for (final Map.Entry<UUID, GenericJob> entry : 
					this.jobsMap.entrySet()) {
					final GenericJob job = entry.getValue();
					final StatusType status = job.getStatus().getStatus();
					switch (status) {					
					case PENDING:
					case EXECUTING:
						pendingJobs.add(new FIFOEntry<GenericJob>(job));
						break;
					case FINISHED:
					case FAILED:
					case CANCELLED:
					default:
						// nothing to do
						break;
					}
				}
			}
		}
		else throw new IllegalArgumentException(
				"A jobs map was already initialized");
	}

	/**
	 * Retrieves the next job from the queue, waiting if necessary until a job 
	 * becomes available.
	 * @return The next job of the queue.
	 */
	public GenericJob nextPendingJob() {
		GenericJob job = null;
		// Wait until next job is available
		try {
			job = pendingJobs.take().getEntry();
		} catch (InterruptedException e) {
			// nothing to do
		}
		return job;
	}

	/**
	 * Inserts the specified job into the priority queue.
	 * @param job The job to add.
	 */
	public void schedulePendingJob(final GenericJob job) {
		try {
			// Check whether the job exists in the list
			final FIFOEntry<GenericJob> fifoEntry = 
					new FIFOEntry<GenericJob>(job);
			if (!pendingJobs.contains(fifoEntry))
				pendingJobs.put(fifoEntry);
		} catch (InterruptedException e) {
			// nothing to do
		}
	}

	/**
	 * Register a new job.
	 * @param uuid Unequally identifies the job.
	 * @param job The job to add.
	 */
	public void registerNewJob(final GenericJob job) {
		jobsMap.put(job.getUUID(), job);
	}

	/**
	 * Returns the job to which the specified <code>uuid</code> is mapped, or 
	 * <code>null</code> if this map contains no mapping for the 
	 * <code>uuid</code>.
	 * @param uuid Unequally identifies the job.
	 * @return The job to which the specified <code>uuid</code> is mapped, or 
	 *         <code>null</code> if this map contains no mapping for the 
	 *         <code>uuid</code>.
	 */
	public GenericJob getJob(final UUID uuid) {
		GenericJob job = null;
		if (uuid != null)
			job = jobsMap.get(uuid);
		return job;
	}

	public void cancelJob(final UUID uuid) {
		final GenericJob job = getJob(uuid);
		if (job != null) {
			synchronized (pendingJobs) {				
				job.cancel();
				schedulePendingJob(job);
			}			
		}
	}

}
