package org.gcube.application.enm.service.conn;

import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.request.InstanceType;

/**
 * A client to the gCube Information System.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class InformationSystemClient {

	public static final String COMPSS_JOB_PLUGIN = 
			"org.gcube.application.enm.service.plugins.comps.COMPSsJob";
	public static final String OMWS_JOB_PLUGIN = 
			"org.gcube.application.enm.service.plugins.omws.OMWSJob";

	public static final String COMPSS_EXECUTION_RESOURCE_PLUGIN = 
			"org.gcube.application.enm.service.plugins.comps.COMPsExecutionResource";
	
	public String getJobPluginName(final ExperimentRequest request) {
		return COMPSS_JOB_PLUGIN;
	}

	public String getExecutionResourcePluginName(
			final ExperimentRequest request) {
		return COMPSS_EXECUTION_RESOURCE_PLUGIN;
	}

	public FtpCredentials getCOMPSFtpCredentials() {
		return new FtpCredentials("bscgrid20.bsc.es", 21, "openbiotest", 
				"openbiotest");
	}

	public COMPSsCredentials getCOMPSsCredentials() {
		return new COMPSsCredentials(
				"https://bscgrid20.bsc.es/venusbes/factory", 
				"openbiotest", "openbiotest", 
				"openbiotest", "openbiotest");
	}

	public OpenModellerImage getOpenModellerImage() {
		return new OpenModellerImage(30, "openbiodebianbase",
				"ftp://bscgrid20.bsc.es/openbiotest/repo/Modeller.tar.gz",
				"openModeller");
	}	
	
	/**
	 * Adds the prefix used in the local filesystem of the execution resource
	 * provider to the layetsets path. For example, relative layerset paths 
	 * looks like: "/layers/...", while execution provider may include 
	 * additional routes to the path: "/sharedDisk/openbio/layers/...".
	 * @return Absolute path to the location of the layersets in the local 
	 *         filesystem of the execution resource provider.
	 */
	public String getCOMPSsLayersetsAbsolutePath(final String path) {
		return "/sharedDisk/openbio" + (path.startsWith("/") ? "" : "/") + path;
	}

	public VmInstance getVmInstance(final InstanceType type) {
		VmInstance instance;
		switch (type) {
		case SMALL:
		case MEDIUM:
		case LARGE:
		default:
			instance = new VmInstance(1.0, 2, 1.0, 0, 3);
			break;
		}
		return instance;
	}

	public class FtpCredentials {
		private final String server;
		private int port;
		private final String username;
		private final String password;
		public FtpCredentials(final String server, final int port, 
				final String username, final String password) {
			this.server = server;
			this.port = port;
			this.username = username;
			this.password = password;
		}
		public final String getServer() {
			return server;
		}
		public final int getPort() {
			return port;
		}
		public final String getUsername() {
			return username;
		}
		public final String getPassword() {
			return password;
		}
	}

	public class COMPSsCredentials {
		private final String endpoint;
		private final String besUsername;
		private final String besPassword;
		private final String storageUsername;
		private final String storagePassword;
		public COMPSsCredentials(final String endpoint, 
				final String besUsername, final String besPassword, 
				final String storageUsername, final String storagePassword) {
			this.endpoint = endpoint;
			this.besUsername = besUsername;
			this.besPassword = besPassword;
			this.storageUsername = storageUsername;
			this.storagePassword = storagePassword;
		}		
		public final String getEndpoint() {
			return endpoint;
		}
		public final String getBesUsername() {
			return besUsername;
		}
		public final String getBesPassword() {
			return besPassword;
		}
		public final String getStorageUsername() {
			return storageUsername;
		}
		public final String getStoragePassword() {
			return storagePassword;
		}		
	}

	public class OpenModellerImage {
		private final int wallClock;
		private final String vmImage;
		private final String appLocation;
		private final String jobNamePrefix;
		public OpenModellerImage(final int wallClock, final String vmImage,
				final String appLocation, final String jobNamePrefix) {			
			this.wallClock = wallClock;
			this.vmImage = vmImage;
			this.appLocation = appLocation;
			this.jobNamePrefix = jobNamePrefix;
		}
		public final int getWallClock() {
			return wallClock;
		}
		public final String getVmImage() {
			return vmImage;
		}
		public final String getAppLocation() {
			return appLocation;
		}
		public final String getJobNamePrefix() {
			return jobNamePrefix;
		}		
	}

	public class VmInstance {
		private final double disSizeGB;
		private final int cores;
		private final double memoryGB;
		private final int minVMs;
		private final int maxVMs;
		public VmInstance(final double disSizeGB, final int cores, 
				final double memoryGB, final int minVMs, final int maxVMs) {
			this.disSizeGB = disSizeGB;
			this.cores = cores;
			this.memoryGB = memoryGB;
			this.minVMs = minVMs;
			this.maxVMs = maxVMs;
		}
		public final double getDisSizeGB() {
			return disSizeGB;
		}
		public final int getCores() {
			return cores;
		}
		public final double getMemoryGB() {
			return memoryGB;
		}
		public final int getMinVMs() {
			return minVMs;
		}
		public final int getMaxVMs() {
			return maxVMs;
		}		
	}	

}
