package org.gcube.application.enm.service.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.stream.StreamSource;

import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;

/**
 * Helper class to import/export XML-binding types from/to files.
 *
 * @author Erik Torres <ertorser@upv.es>
 */
public class XmlHelper {

	private static JAXBContext context;

	static{
		try {
			context = JAXBContext.newInstance(
					ExperimentRequest.class, 
					ExperimentStatus.class, 
					ExperimentResults.class, 
					ExperimentLogs.class);
		} catch (JAXBException e) {}
	}	

	public static <E extends Serializable> void typeToXmlFile(final E input,
			final File file) throws IOException {
		try {
			final Marshaller marshaller = context.createMarshaller();
			final OutputStream os = new FileOutputStream(file, false);
			marshaller.marshal(input, os);
		} catch (JAXBException e) {
			throw new IOException(e.getLocalizedMessage());
		}
	}

	@SuppressWarnings("unchecked")
	public static <E extends Serializable> E xmlFileToType(
			final File file) throws IOException {
		try {
			final Unmarshaller unmarshaller = context.createUnmarshaller();
			return (E) unmarshaller.unmarshal(new StreamSource(file));
		} catch (JAXBException e) {
			throw new IOException(e.getLocalizedMessage());
		}
	}

	public static XMLGregorianCalendar now()
			throws DatatypeConfigurationException {
		final GregorianCalendar gregorianCalendar = new GregorianCalendar();
		final DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
		return datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
	}

	public static Duration durationUntilNow(
			final XMLGregorianCalendar startDate)
					throws DatatypeConfigurationException {
		final GregorianCalendar gregorianCalendar = new GregorianCalendar();
		final long date2 = gregorianCalendar.getTime().getTime();
		final long date1 = startDate.toGregorianCalendar().getTime().getTime();
		final DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
		return datatypeFactory.newDuration(date2 - date1);
	}	

}
