/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.resumes.ExperimentResumes;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.application.enm.service.PluginLoader;
import org.gcube.application.enm.service.concurrent.JobExecutionPool;
import org.gcube.application.enm.service.concurrent.JobMonitor;
import org.gcube.application.enm.service.concurrent.JobScheduler;
import org.gcube.application.enm.service.concurrent.ShutdownHook;
import org.gcube.application.enm.service.conn.InformationSystemClient;
import org.gcube.application.enm.service.conn.PersistenceClient;
import org.gcube.common.core.utils.logging.GCUBELog;

public class ENMService {
    protected GCUBELog logger = new GCUBELog(ENMService.class);
    private final InformationSystemClient isClient = new InformationSystemClient();
    private final PersistenceClient persistenceClient = new PersistenceClient();
    private final PluginLoader pluginLoader = new PluginLoader();

    public ENMService() {
        this.logger.trace((Object)"Constructor...");
        ShutdownHook shutdownHook = new ShutdownHook();
        shutdownHook.attachShutDownHook();
        JobMonitor.get().init(this.loadPendingJobs());
        JobExecutionPool.get().start();
        JobScheduler.get().start();
    }

    public String sumbitExperiment(ExperimentRequest request) throws RemoteException {
        String experimentId = "";
        try {
            String pluginName = this.isClient.getJobPluginName(request);
            GenericJob job = this.pluginLoader.getNewJobInstance(this.createUUID(), request, pluginName);
            if (job != null) {
                if (!JobMonitor.get().registerNewJob(job)) {
                    throw new IOException("Cannot create a job for the experiment");
                }
            } else {
                throw new IllegalArgumentException("Cannot find an execution plugin for the experiment");
            }
            JobExecutionPool.get().submit(job);
            experimentId = job.getUUID().toString();
        }
        catch (Exception e) {
            experimentId = "";
            throw new RemoteException(e.getLocalizedMessage());
        }
        return experimentId;
    }

    public ExperimentStatus getStatus(String experimentId) throws RemoteException {
        ExperimentStatus status = null;
        UUID uuid = this.getUUIDFromString(experimentId);
        GenericJob job = JobMonitor.get().getJob(uuid);
        if (job != null) {
            status = job.getStatus();
        }
        return status;
    }

    public ExperimentResults getResults(String experimentId) throws RemoteException {
        ExperimentResults results = null;
        UUID uuid = this.getUUIDFromString(experimentId);
        GenericJob job = JobMonitor.get().getJob(uuid);
        if (job != null) {
            results = job.getResults();
        }
        return results;
    }

    public ExperimentLogs getLogs(String experimentId) throws RemoteException {
        ExperimentLogs logs = null;
        UUID uuid = this.getUUIDFromString(experimentId);
        GenericJob job = JobMonitor.get().getJob(uuid);
        if (job != null) {
            logs = job.getLogs();
        }
        return logs;
    }

    public void cancelExperiment(String experimentId) throws RemoteException {
        UUID uuid = this.getUUIDFromString(experimentId);
        JobMonitor.get().cancelJob(uuid);
    }

    public ExperimentResumes getUserExperimentResumes(String credentials) throws RemoteException {
        try {
            return this.persistenceClient.getUserExperimentResumes(credentials);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage());
        }
    }

    public void removeExperiment(String experimentId) throws RemoteException {
        UUID uuid = this.getUUIDFromString(experimentId);
        JobMonitor.get().removeJob(uuid);
    }

    private ConcurrentMap<UUID, GenericJob> loadPendingJobs() {
        ConcurrentHashMap<UUID, GenericJob> jobsMap = new ConcurrentHashMap<UUID, GenericJob>();
        this.persistenceClient.loadJobs(jobsMap);
        return jobsMap;
    }

    private UUID createUUID() {
        return UUID.randomUUID();
    }

    private UUID getUUIDFromString(String experimentId) throws RemoteException {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(experimentId);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage());
        }
        return uuid;
    }
}

