package org.gcube.application.enm.service.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * General file utilities.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class FileUtils {

	public static String[] listAllDirs(final String dirPath) {
		final List<String> dirList = new ArrayList<String>();
		final File dir = new File(dirPath);
		final File[] files = dir.listFiles();
		if (files != null && files.length > 0) {
			for (File file : files) {
				if (file.isDirectory())
					dirList.add(file.getAbsolutePath());
			}
		}
		return dirList.toArray(new String[dirList.size()]);
	}

	public static String[] listAllFiles(final String dirPath,
			final String ext) {
		final File dir = new File(dirPath);
		final FilenameFilter filter = new FilenameFilter() {
			public boolean accept(final File dir, final String name) {
				return name.endsWith(ext);
			}
		};
		final String[] files = dir.list(filter);
		if (files != null && files.length > 0) {
			final String dirPath1 = (dirPath.endsWith(File.separator)) 
					? dirPath : dirPath + File.separator;
			for (int i = 0; i < files.length; i++)
				files[i] = dirPath1 + files[i];
		}
		return files;
	}

	public static void deleteDirRecursive(final File dir) throws IOException {
		if (dir != null && dir.isDirectory()) {
			final File[] files = dir.listFiles();
			if (files != null && files.length > 0) {
				for (File file : files) {
					// Recurse into the directory
					if (file.isDirectory()) {  
						deleteDirRecursive(file);
					} else {
						file.delete();
					}
				}
				// Delete directory
				dir.delete();
			}
		}
	}

}
