/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.concurrent;

import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.common.core.utils.logging.GCUBELog;

public class JobExecutionPool {
    protected GCUBELog logger = new GCUBELog(JobExecutionPool.class);
    private static final int NUM_WORKERS = 2;
    private static final int TIMEOUT_SECS = 20;
    private final ExecutorService pool;
    private final CompletionService<String> completion;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AtomicBoolean shouldRun = new AtomicBoolean(true);
    private static JobExecutionPool instance;

    public static JobExecutionPool get() {
        if (instance == null) {
            instance = new JobExecutionPool();
        }
        return instance;
    }

    private JobExecutionPool() {
        this.logger.trace((Object)"Constructor with 2 thread workers");
        this.pool = Executors.newFixedThreadPool(2);
        this.completion = new ExecutorCompletionService<String>(this.pool);
    }

    public void start() {
        if (!this.isStarted.get()) {
            this.isStarted.set(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (JobExecutionPool.this.shouldRun.get()) {
                        try {
                            String res = (String)JobExecutionPool.this.completion.take().get();
                            if (res == null) continue;
                            JobExecutionPool.this.logger.trace((Object)("Job Completed: " + res));
                        }
                        catch (InterruptedException res) {
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() != null) {
                                JobExecutionPool.this.logger.error((Object)("Job failed with the exception: " + e.getCause().getLocalizedMessage()));
                                continue;
                            }
                            JobExecutionPool.this.logger.error((Object)"Job failed with unkown causes");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }).start();
        }
    }

    public final void shutdownAndAwaitTermination() {
        this.pool.shutdown();
        try {
            try {
                if (!this.pool.awaitTermination(20L, TimeUnit.SECONDS)) {
                    this.pool.shutdownNow();
                    if (!this.pool.awaitTermination(20L, TimeUnit.SECONDS)) {
                        this.logger.warn((Object)"Pool did not terminate");
                    }
                }
                this.shouldRun.set(false);
            }
            catch (InterruptedException ie) {
                this.pool.shutdownNow();
                Thread.currentThread().interrupt();
                this.logger.trace((Object)"Exit Thread Pool");
            }
        }
        finally {
            this.logger.trace((Object)"Exit Thread Pool");
        }
    }

    public void submit(GenericJob job) {
        try {
            this.completion.submit(job);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

