/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.application.enm.service.concurrent.JobExecutionPool;
import org.gcube.application.enm.service.concurrent.JobMonitor;
import org.gcube.common.core.utils.logging.GCUBELog;

public class JobScheduler {
    protected GCUBELog logger = new GCUBELog(JobScheduler.class);
    private static final int NUM_WORKERS = 1;
    private static final int TIMEOUT_SECS = 20;
    public static final long INITIAL_DELAY = 10L;
    public static final long JOB_EXEC_DELAY = 30L;
    public static final int MAX_JOBS_PER_RUN = 1000;
    public static final long CLEAUNP_TIME_MILLIS = 3600000L;
    private long lastClean = System.currentTimeMillis() + 3600000L;
    private final ScheduledExecutorService pool;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AtomicBoolean shouldRun = new AtomicBoolean(true);
    private static JobScheduler instance;

    public static JobScheduler get() {
        if (instance == null) {
            instance = new JobScheduler();
        }
        return instance;
    }

    private JobScheduler() {
        this.logger.trace((Object)"Constructor with 1 thread workers");
        this.pool = Executors.newScheduledThreadPool(1);
    }

    public void start() {
        if (!this.isStarted.get()) {
            this.isStarted.set(true);
            this.pool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (System.currentTimeMillis() - JobScheduler.this.lastClean > 3600000L) {
                        JobMonitor.get().clean();
                        JobScheduler.this.lastClean = System.currentTimeMillis();
                    }
                    int jobCount = Math.min(JobMonitor.get().numPendingJobs(), 1000);
                    int i = 0;
                    while (i < jobCount) {
                        GenericJob job = JobMonitor.get().nextPendingJob();
                        JobExecutionPool.get().submit(job);
                        JobScheduler.this.logger.trace((Object)("Job '" + job.getUUID() + "' re-scheduled"));
                        ++i;
                    }
                }
            }, 10L, 30L, TimeUnit.SECONDS);
        }
    }

    public final void shutdownAndAwaitTermination() {
        this.shouldRun.set(false);
        this.pool.shutdown();
        try {
            try {
                if (!this.pool.awaitTermination(20L, TimeUnit.SECONDS)) {
                    this.pool.shutdownNow();
                    if (!this.pool.awaitTermination(20L, TimeUnit.SECONDS)) {
                        this.logger.warn((Object)"Scheduler did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.pool.shutdownNow();
                Thread.currentThread().interrupt();
                this.logger.trace((Object)"Exit Scheduler");
            }
        }
        finally {
            this.logger.trace((Object)"Exit Scheduler");
        }
    }
}

