package org.gcube.application.enm.context;

import org.gcube.application.enm.Constants;
import org.gcube.application.enm.service.ENMService;
import org.gcube.common.core.contexts.GCUBEServiceContext;

/**
 * Setups gCube context for the service.
 * 
 * @author Lucio Lelii <lucio.lelii@isti.cnr.it>
 */
public class ServiceContext extends GCUBEServiceContext {	

	private ENMService service;

	/** Single context instance, created eagerly */
	private static ServiceContext cache = new ServiceContext();

	/** Returns cached instance */
	public static ServiceContext getContext() {return cache;}

	@Override
	protected void onReady() throws Exception {
		service = new ENMService();
		super.onReady();
	}

	@Override
	protected String getJNDIName() {
		return Constants.JNDI_NAME;
	}

	public ENMService getENMService() {
		return service;
	}

}
