package org.gcube.application.enm.service;

import java.lang.reflect.Constructor;
import java.util.UUID;

import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * Loads the different execution resource providers into the service. Providers
 * must extend {@link ExecutionResource}, overriding the 
 * {@link ExecutionResource#ExecutionResource()} constructor. Also, they must
 * extend {@link GenericJob}, overriding the constructors of
 * this class: 
 * {@link GenericJob#GenericJob(UUID, ExperimentRequest)} and 
 * {@link GenericJob#GenericJob(UUID, ExperimentRequest, ExperimentStatus, ExperimentResults, ExperimentLogs)}.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class PluginLoader {

	protected GCUBELog logger = new GCUBELog(PluginLoader.class);	

	public PluginLoader() {
		// Setup logging
		logger.trace("Constructor...");
	}

	public GenericJob getNewJobInstance(final UUID uuid,
			final ExperimentRequest request, final String pluginName) {
		GenericJob instance = null;
		try {
			final Class< ? >[] argsTypes = new Class< ? >[] { UUID.class, 
					ExperimentRequest.class };
			final Class< ? > clazz = Class.forName(pluginName);
			final Constructor< ? > cons = clazz.getConstructor(argsTypes);
			final Object[] args = new Object[] { uuid, request };
			instance = (GenericJob) cons.newInstance(args);
			logger.trace("Plugin successfully loaded: " + pluginName);
		} catch (Exception e) {
			logger.error("Failed to load job plugin: " 
					+ e.getLocalizedMessage());
		}
		return instance;
	}

	public GenericJob getNewJobInstance(final UUID uuid, 
			final ExperimentRequest request, final ExperimentStatus status, 
			final ExperimentResults results, final ExperimentLogs logs, 
			final String pluginName) {
		GenericJob instance = null;
		try {
			final Class< ? >[] argsTypes = new Class< ? >[] { UUID.class, 
					ExperimentRequest.class, ExperimentStatus.class,
					ExperimentResults.class, ExperimentLogs.class };
			final Class< ? > clazz = Class.forName(pluginName);
			final Constructor< ? > cons = clazz.getConstructor(argsTypes);
			final Object[] args = new Object[] { uuid, request, status, 
					results, logs };
			instance = (GenericJob) cons.newInstance(args);
			logger.trace("Plugin successfully loaded: " + pluginName);
		} catch (Exception e) {
			logger.error("Failed to load job plugin: " 
					+ e.getLocalizedMessage() + (e.getCause() != null 
					? ". Cause: " + e.getCause().getLocalizedMessage() : ""));
		}
		return instance;
	}

	public ExecutionResource getNewExecutionResourceInstance(
			final String pluginName) {
		ExecutionResource instance = null;
		try {
			final Class< ? >[] argsTypes = new Class< ? >[] { };
			final Class< ? > clazz = Class.forName(pluginName);
			final Constructor< ? > cons = clazz.getConstructor(argsTypes);
			final Object[] args = new Object[] { };
			instance = (ExecutionResource) cons.newInstance(args);
			logger.trace("Plugin successfully loaded: " + pluginName);
		} catch (Exception e) {
			logger.error("Failed to load execution resource plugin: " 
					+ e.getLocalizedMessage());
		}
		return instance;
	}

}
