/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.concurrent;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.gcube.application.enm.common.xml.status.StatusType;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.application.enm.service.concurrent.FIFOEntry;

@Deprecated
public class JobMonitorBlocking {
    private final BlockingQueue<FIFOEntry<GenericJob>> pendingJobs = new PriorityBlockingQueue<FIFOEntry<GenericJob>>();
    private ConcurrentMap<UUID, GenericJob> jobsMap = null;
    private static JobMonitorBlocking instance;

    public static JobMonitorBlocking get() {
        if (instance == null) {
            instance = new JobMonitorBlocking();
        }
        return null;
    }

    public synchronized void init(ConcurrentMap<UUID, GenericJob> jobsMap) throws IllegalArgumentException {
        if (this.jobsMap == null) {
            this.jobsMap = jobsMap;
            if (this.jobsMap != null) {
                for (Map.Entry entry : this.jobsMap.entrySet()) {
                    GenericJob job = (GenericJob)entry.getValue();
                    StatusType status = job.getStatus().getStatus();
                    switch (status) {
                        case PENDING: 
                        case EXECUTING: {
                            this.pendingJobs.add(new FIFOEntry<GenericJob>(job));
                            break;
                        }
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("A jobs map was already initialized");
        }
    }

    public GenericJob nextPendingJob() {
        GenericJob job = null;
        try {
            job = this.pendingJobs.take().getEntry();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return job;
    }

    public void schedulePendingJob(GenericJob job) {
        try {
            FIFOEntry<GenericJob> fifoEntry = new FIFOEntry<GenericJob>(job);
            if (!this.pendingJobs.contains(fifoEntry)) {
                this.pendingJobs.put(fifoEntry);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void registerNewJob(GenericJob job) {
        this.jobsMap.put(job.getUUID(), job);
    }

    public GenericJob getJob(UUID uuid) {
        GenericJob job = null;
        if (uuid != null) {
            job = (GenericJob)this.jobsMap.get(uuid);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJob(UUID uuid) {
        GenericJob job = this.getJob(uuid);
        if (job != null) {
            BlockingQueue<FIFOEntry<GenericJob>> blockingQueue = this.pendingJobs;
            synchronized (blockingQueue) {
                job.cancel();
                this.schedulePendingJob(job);
            }
        }
    }
}

