/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.conn;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.resumes.ExperimentResumeType;
import org.gcube.application.enm.common.xml.resumes.ExperimentResumes;
import org.gcube.application.enm.common.xml.resumes.ObjectFactory;
import org.gcube.application.enm.common.xml.resumes.StatusType;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.context.ServiceContext;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.application.enm.service.PluginLoader;
import org.gcube.application.enm.service.conn.InformationSystemClient;
import org.gcube.application.enm.service.conn.JobUpdate;
import org.gcube.application.enm.service.util.FileUtils;
import org.gcube.application.enm.service.util.XmlHelper;
import org.gcube.common.core.utils.logging.GCUBELog;

public class PersistenceClient {
    protected GCUBELog logger = new GCUBELog(PersistenceClient.class);
    public static final String REQUEST_FILENAME = "request.xml";
    public static final String STATUS_FILENAME = "status.xml";
    public static final String RESULTS_FILENAME = "results.xml";
    public static final String LOGS_FILENAME = "logs.xml";
    public static final File PERSISTENCE_ROOT = ServiceContext.getContext().getPersistenceRoot();
    public static String PERSISTENCE_ROOT_PATH;

    static {
        try {
            PERSISTENCE_ROOT_PATH = PERSISTENCE_ROOT.getCanonicalPath();
        }
        catch (Exception e) {
            PERSISTENCE_ROOT_PATH = null;
        }
    }

    public PersistenceClient() {
        this.logger.trace((Object)"Constructor...");
    }

    public void write(GenericJob job) throws IOException {
        this.write(job, new JobUpdate());
    }

    public void write(GenericJob job, JobUpdate updates) throws IOException {
        this.validate(job);
        File dir = this.getBasedir(job);
        boolean isNewJobCreated = dir.mkdirs();
        if (isNewJobCreated) {
            XmlHelper.typeToXmlFile(job.getRequest(), new File(dir, REQUEST_FILENAME));
        }
        if (updates.isStatusChange()) {
            XmlHelper.typeToXmlFile(job.getStatus(), new File(dir, STATUS_FILENAME));
        }
        if (updates.isResultsChange()) {
            XmlHelper.typeToXmlFile(job.getResults(), new File(dir, RESULTS_FILENAME));
        }
        if (updates.isLogsChange()) {
            XmlHelper.typeToXmlFile(job.getLogs(), new File(dir, LOGS_FILENAME));
        }
        this.logger.trace((Object)("Experiment '" + job.getUUID().toString() + "' updated"));
    }

    public GenericJob read(String credentials, UUID experimentId) throws IOException {
        try {
            File dir = this.getBasedir(credentials, experimentId);
            ExperimentRequest request = (ExperimentRequest)XmlHelper.xmlFileToType(new File(dir, REQUEST_FILENAME));
            ExperimentStatus status = (ExperimentStatus)XmlHelper.xmlFileToType(new File(dir, STATUS_FILENAME));
            ExperimentResults results = (ExperimentResults)XmlHelper.xmlFileToType(new File(dir, RESULTS_FILENAME));
            ExperimentLogs logs = (ExperimentLogs)XmlHelper.xmlFileToType(new File(dir, LOGS_FILENAME));
            String pluginName = new InformationSystemClient().getJobPluginName(request);
            GenericJob job = new PluginLoader().getNewJobInstance(experimentId, request, status, results, logs, pluginName);
            this.validate(job);
            return job;
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public final void delete(GenericJob job) throws IOException {
        FileUtils.deleteDirRecursive(this.getBasedir(job));
        this.logger.trace((Object)("The experiment '" + job.getUUID().toString() + "' was permanently removed"));
    }

    public String findCredentials(UUID experimentId) {
        if (experimentId != null) {
            String[] userDirs;
            String[] stringArray = userDirs = FileUtils.listAllDirs(PERSISTENCE_ROOT_PATH);
            int n = userDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] jobDirs;
                String userDir = stringArray[n2];
                String credentials = new File(userDir).getName();
                String[] stringArray2 = jobDirs = FileUtils.listAllDirs(userDir);
                int n3 = jobDirs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jobDir = stringArray2[n4];
                    UUID itemId = UUID.fromString(new File(jobDir).getName());
                    if (itemId.equals(experimentId)) {
                        return credentials;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public void loadJobs(ConcurrentMap<UUID, GenericJob> jobsMap) {
        this.loadJobs(jobsMap, true);
    }

    public void loadJobs(ConcurrentMap<UUID, GenericJob> jobsMap, boolean pending) {
        String[] userDirs;
        this.logger.trace((Object)("Loading jobs from '" + PERSISTENCE_ROOT_PATH + "'"));
        String[] stringArray = userDirs = FileUtils.listAllDirs(PERSISTENCE_ROOT_PATH);
        int n = userDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] jobDirs;
            String userDir = stringArray[n2];
            String credentials = new File(userDir).getName();
            String[] stringArray2 = jobDirs = FileUtils.listAllDirs(userDir);
            int n3 = jobDirs.length;
            int n4 = 0;
            while (n4 < n3) {
                String jobDir = stringArray2[n4];
                UUID experimentId = UUID.fromString(new File(jobDir).getName());
                try {
                    boolean load = true;
                    GenericJob job = this.read(credentials, experimentId);
                    if (pending) {
                        switch (job.getStatus().getStatus()) {
                            case PENDING: 
                            case EXECUTING: {
                                load = true;
                                break;
                            }
                            default: {
                                load = false;
                            }
                        }
                    }
                    if (load) {
                        jobsMap.put(experimentId, job);
                        this.logger.trace((Object)("Job loaded: '" + experimentId + "'"));
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to load experiment '" + experimentId.toString() + "': " + e.getLocalizedMessage()));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public ExperimentResumes getUserExperimentResumes(String credentials) throws IOException {
        File userDir = this.getUserdir(credentials);
        String[] jobDirs = FileUtils.listAllDirs(userDir.getCanonicalPath());
        ExperimentResumes experimentResumes = new ObjectFactory().createExperimentResumes();
        experimentResumes.setExperimentResumes(new ObjectFactory().createExperimentResumesType());
        experimentResumes.setCredentials(credentials);
        String[] stringArray = jobDirs;
        int n = jobDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String jobDir = stringArray[n2];
            UUID experimentId = UUID.fromString(new File(jobDir).getName());
            GenericJob job = this.read(credentials, experimentId);
            experimentResumes.getExperimentResumes().getExperimentResume().add(this.resume(job));
            ++n2;
        }
        return experimentResumes;
    }

    private ExperimentResumeType resume(GenericJob job) {
        ExperimentResumeType resume = new ObjectFactory().createExperimentResumeType();
        resume.setUuid(job.getUUID().toString());
        resume.setName(job.getRequest().getName());
        resume.setStatus(StatusType.fromValue((String)job.getStatus().getStatus().value()));
        resume.setCompletenessPercentage(job.getStatus().getCompletenessPercentage());
        resume.setStartDate(job.getStatus().getStartDate());
        resume.setEndDate(job.getStatus().getEndDate());
        return resume;
    }

    private void validate(GenericJob job) throws IOException {
        if (job == null) {
            throw new IOException("Job cannot be null");
        }
        if (job.getUUID() == null) {
            throw new IOException("Experiment Id cannot be null");
        }
        if (job.getRequest() == null) {
            throw new IOException("Request cannot be null");
        }
        if (job.getRequest().getCredentials() == null || job.getRequest().getCredentials().length() < 3) {
            throw new IOException("Invalid user credentials");
        }
        if (job.getRequest().getName() == null || job.getRequest().getName().length() < 3) {
            throw new IOException("Invalid job name");
        }
        if (job.getStatus() == null) {
            throw new IOException("Status cannot be null");
        }
        if (job.getResults() == null) {
            throw new IOException("Results cannot be null");
        }
        if (job.getLogs() == null) {
            throw new IOException("Logs cannot be null");
        }
    }

    private File getBasedir(GenericJob job) throws IOException {
        return this.getBasedir(job.getRequest().getCredentials(), job.getUUID());
    }

    private File getBasedir(String credentials, UUID experimentId) throws IOException {
        return new File(this.getUserdir(credentials), experimentId.toString());
    }

    private File getUserdir(String credentials) throws IOException {
        return new File(PERSISTENCE_ROOT.getCanonicalPath(), credentials);
    }
}

