/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;

public class XmlHelper {
    private static JAXBContext context;

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{ExperimentRequest.class, ExperimentStatus.class, ExperimentResults.class, ExperimentLogs.class});
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public static <E extends Serializable> void typeToXmlFile(E input, File file) throws IOException {
        try {
            Marshaller marshaller = context.createMarshaller();
            FileOutputStream os = new FileOutputStream(file, false);
            marshaller.marshal(input, (OutputStream)os);
        }
        catch (JAXBException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static <E extends Serializable> E xmlFileToType(File file) throws IOException {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (E)((Serializable)unmarshaller.unmarshal((Source)new StreamSource(file)));
        }
        catch (JAXBException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static XMLGregorianCalendar now() throws DatatypeConfigurationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        return datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    public static Duration durationUntilNow(XMLGregorianCalendar startDate) throws DatatypeConfigurationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long date2 = gregorianCalendar.getTime().getTime();
        long date1 = startDate.toGregorianCalendar().getTime().getTime();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        return datatypeFactory.newDuration(date2 - date1);
    }
}

