/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.Constants;
import org.gcube.data.spd.gbifplugin.search.Utils;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public abstract class AbstractSearch<T> {
    private static GCUBELog logger = new GCUBELog(AbstractSearch.class);
    protected static XMLInputFactory ifactory = XMLInputFactory.newInstance();
    protected String providerKey;
    protected String dataSetKey;
    protected String elementsTag;
    protected Property[] properties;

    public AbstractSearch(String elementsTag, Property ... properties) {
        this.elementsTag = elementsTag;
        this.properties = properties != null ? properties : new Property[]{};
    }

    protected synchronized void search(ObjectWriter<T> writer, URL searchUrl) throws Exception {
        logger.debug((Object)"starting search ");
        InputStream is = searchUrl.openConnection().getInputStream();
        XMLEventReader eventReader = ifactory.createXMLEventReader(is);
        String nextResultsLink = null;
        URL nextresultURL = null;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "nextRequestUrl")) {
                nextResultsLink = Utils.readCharacters(eventReader).replace(" ", "");
                continue;
            }
            if (!Utils.checkStartElement(event, "dataProviders")) continue;
            if (!this.pagingSearch(eventReader, writer)) break;
            if (nextResultsLink == null) continue;
            nextresultURL = new URL(nextResultsLink);
            is = nextresultURL.openConnection().getInputStream();
            eventReader = ifactory.createXMLEventReader(is);
        }
        logger.debug((Object)"search finished ");
    }

    private boolean pagingSearch(XMLEventReader eventReader, ObjectWriter<T> writer) throws Exception {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!Utils.checkStartElement(event, "dataProvider")) continue;
            if (!this.retrieveDataProvider(eventReader, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), writer)) {
                return false;
            }
            if (!Utils.checkEndElement(event, "dataProviders")) continue;
            break;
        }
        return true;
    }

    private boolean retrieveDataProvider(XMLEventReader eventReader, String gbifKey, ObjectWriter<T> writer) throws Exception {
        ArrayList<T> elements = new ArrayList<T>();
        DataProvider dataProvider = new DataProvider(gbifKey);
        this.providerKey = gbifKey;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "name")) {
                event = eventReader.nextEvent();
                dataProvider.setName(event.asCharacters().getData());
                continue;
            }
            if (Utils.checkStartElement(event, "dataResource")) {
                elements.addAll(this.retrieveDataSet(eventReader, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), event.asStartElement().getAttributeByName(Constants.ABOUT_ATTR).getValue(), dataProvider));
                continue;
            }
            if (!Utils.checkEndElement(event, "dataProvider")) continue;
            for (Object element : elements) {
                writer.put(element);
            }
        }
        return true;
    }

    private List<T> retrieveDataSet(XMLEventReader eventReader, String resourceId, String resourceUri, DataProvider dataProvider) throws Exception {
        List<Object> elements = new ArrayList();
        this.dataSetKey = resourceId;
        DataSet dataSet = new DataSet(resourceId);
        dataSet.setDataProvider(dataProvider);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "name")) {
                dataSet.setName(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "citation")) {
                dataSet.setCitation(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, this.elementsTag)) {
                elements = this.retrieveElements(eventReader, false, dataSet);
                continue;
            }
            if (!Utils.checkEndElement(event, "dataResource")) continue;
            break;
        }
        return elements;
    }

    protected abstract List<T> retrieveElements(XMLEventReader var1, boolean var2, DataSet var3) throws Exception;
}

