/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.capabilities;

import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.search.OccurrenceSearch;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.readers.LocalReader;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class OccurrencesCapabilityImpl
extends OccurrencesCapability {
    private static GCUBELog logger = new GCUBELog(OccurrencesCapabilityImpl.class);
    private String baseUrl;

    public OccurrencesCapabilityImpl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Set<Properties> getSupportedProperties() {
        return new HashSet<Properties>(){
            {
                this.add(Properties.DateTo);
                this.add(Properties.DateFrom);
                this.add(Properties.CoordinateFrom);
                this.add(Properties.CoordinateTo);
            }
        };
    }

    public void searchByCommonName(String word, ObjectWriter<OccurrencePoint> writer, Property ... properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<OccurrencePoint> writer, Property ... properties) {
        try {
            new OccurrenceSearch(this.baseUrl, new Property[0]).search(writer, word);
        }
        catch (Exception e) {
            logger.debug((Object)"search occurrences by ScientificName failed", (Throwable)e);
        }
        finally {
            writer.close();
        }
    }

    public void getOccurrencesByProductKeys(ObjectWriter<OccurrencePoint> writer, LocalReader<String> keys) {
        OccurrenceSearch occSearch = null;
        try {
            occSearch = new OccurrenceSearch(this.baseUrl, new Property[0]);
        }
        catch (Exception e) {
            logger.error((Object)"error contacting gbif server");
            writer.close();
            return;
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                occSearch.searchByKey(writer, key);
            }
            catch (Exception e) {
                logger.warn((Object)("error retrieving key " + key), (Throwable)e);
            }
        }
        writer.close();
    }

    public void getOccurrencesByIds(ObjectWriter<OccurrencePoint> writer, LocalReader<String> ids) {
        OccurrenceSearch occSearch = null;
        try {
            occSearch = new OccurrenceSearch(this.baseUrl, new Property[0]);
        }
        catch (Exception e) {
            logger.error((Object)"error contacting gbif server");
            writer.close();
            return;
        }
        while (ids.hasNext()) {
            String id = (String)ids.next();
            try {
                if (writer.put((Object)occSearch.searchById(id))) continue;
                writer.close();
                logger.trace((Object)"the writer is closed");
                return;
            }
            catch (Exception e) {
                logger.warn((Object)("error retrieving id " + id), (Throwable)e);
            }
        }
        writer.close();
    }
}

