/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.gcube.data.spd.gbifplugin.Constants;
import org.gcube.data.spd.gbifplugin.search.AbstractSearch;
import org.gcube.data.spd.gbifplugin.search.Utils;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

public class GBIFSearch
extends AbstractSearch<ResultItem> {
    private String scientificName;
    private String baseUrl;
    private static XMLInputFactory ifactory = XMLInputFactory.newInstance();

    public GBIFSearch(String baseURL, String scientificName, Property ... properties) throws Exception {
        super("taxonConcepts", properties);
        this.scientificName = scientificName.replaceAll(" ", "%20");
        this.baseUrl = baseURL;
    }

    public void search(ObjectWriter<ResultItem> writer) throws Exception {
        this.search(writer, new URL(this.baseUrl + "taxon/list?scientificname=" + this.scientificName));
    }

    private List<Tree> retrieveTaxons(XMLEventReader eventReader, boolean onlyUri, DataSet dataset) throws Exception {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        while (eventReader.hasNext()) {
            Tree tree;
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "TaxonConcept") && (tree = this.retrieveEntireTaxon(event.asStartElement().getAttributeByName(Constants.ABOUT_ATTR).getValue())) != null) {
                String taxonConceptKey = event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue();
                String productsId = Utils.createProductsKey(this.scientificName, this.providerKey, this.dataSetKey, taxonConceptKey, Utils.elaborateProps(this.properties));
                Edge occurrenceEdge = Nodes.e((String)"product", (Node)Nodes.n((String)productsId, (Edge[])new Edge[]{Nodes.e((String)"type", (Object)Capabilities.Occurences), Nodes.e((String)"count", (Object)this.occurrencesCount(taxonConceptKey))}));
                tree.add(Nodes.e((String)"products", (Node)Nodes.n((Edge[])new Edge[]{occurrenceEdge})));
                Calendar now = Calendar.getInstance();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                String credits = "Biodiversity occurrence data published by: " + dataset.getDataProvider().getName() + " (Accessed through GBIF Data Portal, data.gbif.org, " + format.format(now.getTime()) + ")";
                tree.add(Nodes.e((String)"credits", (Object)credits));
                trees.add(tree);
            }
            if (!Utils.checkEndElement(event, "taxonConcepts")) continue;
            break;
        }
        return trees;
    }

    private Tree retrieveEntireTaxon(String resourceUri) throws Exception {
        URL url = new URL(resourceUri);
        InputStream is = url.openConnection().getInputStream();
        XMLEventReader eventReader = ifactory.createXMLEventReader(is);
        Stack<Edge> stack = new Stack<Edge>();
        String toTaxon = null;
        while (eventReader.hasNext()) {
            String taxonKey;
            Edge edge;
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "TaxonConcept") && (edge = this.retrieveTaxonIternal(eventReader, taxonKey = event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), toTaxon)) != null) {
                toTaxon = edge.target().attribute("taxonRelation");
                stack.push(edge);
            }
            if (!Utils.checkEndElement(event, this.elementsTag)) continue;
            break;
        }
        if (stack.isEmpty()) {
            return null;
        }
        Edge edge = (Edge)stack.pop();
        while (!stack.isEmpty()) {
            Edge tempEdge = (Edge)stack.pop();
            ((InnerNode)tempEdge.target()).add(edge);
            edge = tempEdge;
        }
        return Nodes.t((String)edge.target().id(), (Edge[])((InnerNode)edge.target()).edges().toArray(new Edge[0]));
    }

    private Edge retrieveTaxonIternal(XMLEventReader eventReader, String taxonKey, String oldTaxonValue) throws Exception {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        boolean isChild = false;
        String toTaxon = null;
        String uri = "http://data.gbif.org/ws/rest/taxon/get/" + taxonKey;
        boolean isPrimary = false;
        boolean hasRelationship = false;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "nameComplete")) {
                edges.add(Nodes.e((String)"scientificName", (Object)Utils.readCharacters(eventReader)));
            }
            if (Utils.checkStartElement(event, "rankString")) {
                edges.add(Nodes.e((String)"rank", (Object)Utils.readCharacters(eventReader)));
            }
            if (Utils.checkStartElement(event, "accordingToString")) {
                edges.add(Nodes.e((String)"citation", (Object)Utils.readCharacters(eventReader)));
            }
            if (Utils.checkStartElement(event, "primary")) {
                isPrimary = Utils.readCharacters(eventReader).equals("true");
            }
            if (Utils.checkStartElement(event, "Relationship")) {
                hasRelationship = true;
                while (!Utils.checkEndElement(event, "Relationship")) {
                    event = eventReader.nextEvent();
                    if (Utils.checkStartElement(event, "relationshipCategory")) {
                        isChild = event.asStartElement().getAttributeByName(Constants.RESOURCE_ATTR).getValue().equals("http://rs.tdwg.org/ontology/voc/TaxonConcept#IsChildTaxonOf");
                    }
                    if (!Utils.checkStartElement(event, "toTaxon")) continue;
                    toTaxon = event.asStartElement().getAttributeByName(Constants.RESOURCE_ATTR).getValue();
                }
                if (!isChild) continue;
                break;
            }
            if (!Utils.checkEndElement(event, "TaxonConcept")) continue;
            break;
        }
        if (isPrimary || isChild && uri.equals(oldTaxonValue) || !hasRelationship && uri.equals(oldTaxonValue)) {
            Edge returnEdge = Nodes.e((String)"parent", (Node)Nodes.n((String)taxonKey, (Edge[])edges.toArray(new Edge[edges.size()])));
            returnEdge.target().setAttribute("taxonRelation", toTaxon);
            return returnEdge;
        }
        return null;
    }

    private String occurrencesCount(String taxonKey) throws Exception {
        String occurrencesCount = "0";
        URL url = new URL("http://data.gbif.org/ws/rest/occurrence/count?scientificname=" + this.scientificName + "&dataproviderkey=" + this.providerKey + "&dataresourcekey=" + this.dataSetKey + "&taxonconceptkey=" + taxonKey + "&coordinatestatus=true" + Utils.elaborateProps(this.properties));
        InputStream is = url.openConnection().getInputStream();
        XMLEventReader countEventReader = ifactory.createXMLEventReader(is);
        while (countEventReader.hasNext()) {
            XMLEvent countEvent = countEventReader.nextEvent();
            if (!Utils.checkStartElement(countEvent, "summary")) continue;
            occurrencesCount = countEvent.asStartElement().getAttributeByName(Constants.TOTAL_MATCHED_ATTR).getValue();
            break;
        }
        return occurrencesCount;
    }

    @Override
    protected List<ResultItem> retrieveElements(XMLEventReader eventReader, boolean b, DataSet dataset) throws Exception {
        ArrayList<ResultItem> results = new ArrayList<ResultItem>();
        for (Tree tree : this.retrieveTaxons(eventReader, true, dataset)) {
            tree.add(Nodes.e((String)"dataSet", (Node)Nodes.n((String)dataset.getId(), (Edge[])new Edge[]{Nodes.e((String)"dataProvider", (Node)Nodes.n((String)dataset.getDataProvider().getId(), (Edge[])new Edge[]{Nodes.e((String)"name", (Object)dataset.getDataProvider().getName())})), Nodes.e((String)"citation", (Object)dataset.getCitation()), Nodes.e((String)"name", (Object)dataset.getName())})));
            results.add(ResultItem.fromTree((Tree)tree));
        }
        return results;
    }
}

