/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin;

import java.util.Collections;
import java.util.Set;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.capabilities.OccurrencesCapabilityImpl;
import org.gcube.data.spd.gbifplugin.search.GBIFSearch;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamBlockingException;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamException;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class Plugin
extends AbstractPlugin {
    private GCUBELog logger = new GCUBELog(Plugin.class);
    private OccurrencesCapability occurrencesCapability;
    private String baseURL;

    public void initialize(GCUBERuntimeResource resource) throws Exception {
        this.baseURL = ((AccessPoint)resource.getAccessPoints().get(0)).getEndpoint();
        this.occurrencesCapability = new OccurrencesCapabilityImpl(this.baseURL);
        this.setUseCache(true);
        super.initialize(resource);
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return Collections.singleton(Capabilities.Occurences);
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return this.occurrencesCapability;
    }

    public String getRepositoryName() {
        return "GBIF";
    }

    public String getDescription() {
        return "A plugin for GBIF interaction";
    }

    public void searchByCommonName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
        this.logger.debug((Object)"starting the search for gbifPlugin");
        try {
            new GBIFSearch(this.baseURL, word, properties).search(writer);
        }
        catch (Exception e) {
            this.logger.debug((Object)"searchByScientificName failed", (Throwable)e);
            writer.put((StreamException)new StreamBlockingException());
        }
        finally {
            writer.close();
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        return new RepositoryInfo("http://www.gbif.org/fileadmin/templates/main/images/logo_leaf.gif", "http://www.gbif.org/", "The Global Biodiversity Information Facility (GBIF) was established by governments in 2001 to encourage free and open access to biodiversity data, via the Internet. Through a global network of countries and organizations, GBIF promotes and facilitates the mobilization, access, discovery and use of information about the occurrence of organisms over time and across the planet");
    }
}

