/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.Constants;
import org.gcube.data.spd.gbifplugin.search.AbstractSearch;
import org.gcube.data.spd.gbifplugin.search.Utils;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.model.BasisOfRecord;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.readers.LocalReader;
import org.gcube.data.spd.plugin.fwk.util.ElementProperty;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.plugin.fwk.writers.Writer;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.LocalWrapper;

public class OccurrenceSearch
extends AbstractSearch<OccurrencePoint> {
    String baseUrl;
    private static GCUBELog logger = new GCUBELog(OccurrenceSearch.class);
    private int total = 0;

    public OccurrenceSearch(String baseUrl, Property ... properties) throws Exception {
        super("occurrenceRecords", new Property[0]);
        this.baseUrl = baseUrl;
    }

    public void search(ObjectWriter<OccurrencePoint> writer, String scientificName) throws Exception {
        this.search(writer, new URL(this.baseUrl + "occurrence/list?scientificname=" + scientificName.replace(" ", "%20") + Utils.elaborateProps(this.properties) + "&coordinatestatus=true&format=darwin"));
    }

    public void searchByKey(ObjectWriter<OccurrencePoint> writer, String key) throws Exception {
        logger.trace((Object)(this.baseUrl + "occurrence/list?" + Utils.elaborateProductsKey(key) + "&coordinatestatus=true&format=darwin"));
        this.search(writer, new URL(this.baseUrl + "occurrence/list?" + Utils.elaborateProductsKey(key) + "&coordinatestatus=true&format=darwin"));
    }

    public OccurrencePoint searchById(String id) throws Exception {
        LocalWrapper localWrapper = new LocalWrapper();
        this.search(new Writer((AbstractWrapper)localWrapper), new URL(this.baseUrl + "occurrence/get/" + id + "?format=darwin"));
        LocalReader localReader = new LocalReader(localWrapper);
        if (!localReader.hasNext()) {
            throw new IdNotValidException();
        }
        OccurrencePoint returnObj = (OccurrencePoint)localReader.next();
        localWrapper.close();
        return returnObj;
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        for (BasisOfRecord record : BasisOfRecord.values()) {
            if (!record.name().toLowerCase().equals(value.toLowerCase())) continue;
            return record;
        }
        if (value.toLowerCase().equals("S".toLowerCase())) {
            return BasisOfRecord.PreservedSpecimen;
        }
        if (value.toLowerCase().equals("O".toLowerCase())) {
            return BasisOfRecord.HumanObservation;
        }
        if (value.toLowerCase().equals("fossil")) {
            return BasisOfRecord.FossilSpecimen;
        }
        return BasisOfRecord.HumanObservation;
    }

    @Override
    protected List<OccurrencePoint> retrieveElements(XMLEventReader eventReader, boolean b, DataSet dataset) throws Exception {
        ArrayList<OccurrencePoint> occurrencePointList = new ArrayList<OccurrencePoint>();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "TaxonOccurrence")) {
                occurrencePointList.add(this.retrieveElement(eventReader, dataset, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue()));
                continue;
            }
            if (!Utils.checkEndElement(event, this.elementsTag)) continue;
            logger.trace((Object)("returned occurrences are " + occurrencePointList.size()));
            this.total += occurrencePointList.size();
            logger.trace((Object)("total for now " + this.total));
            return occurrencePointList;
        }
        throw new Exception("parsing exception");
    }

    private OccurrencePoint retrieveElement(XMLEventReader eventReader, DataSet dataset, String occurrenceId) throws Exception {
        OccurrencePoint occurrence = new OccurrencePoint(occurrenceId);
        occurrence.setDataSet(dataset);
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String credits = "Biodiversity occurrence data published by: " + dataset.getDataProvider().getName() + " (Accessed through GBIF Data Portal, data.gbif.org, " + format.format(now.getTime()) + ")";
        occurrence.setCredits(credits);
        while (eventReader.hasNext()) {
            Calendar calendar;
            SimpleDateFormat df;
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "collectionCode")) {
                occurrence.setCollectionCode(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "institutionCode")) {
                occurrence.setInstitutionCode(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "catalogNumber")) {
                occurrence.setCatalogueNumber(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "rights")) {
                occurrence.addProperty(new ElementProperty("rignts", Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "collector")) {
                occurrence.setRecordedBy(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "country")) {
                occurrence.setCountry(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "locality")) {
                occurrence.setLocality(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "earliestDateCollected")) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                calendar = Calendar.getInstance();
                calendar.setTime(df.parse(Utils.readCharacters(eventReader).replace(" ", "")));
                occurrence.setEventDate(calendar);
                continue;
            }
            if (Utils.checkStartElement(event, "latestDateCollected")) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                calendar = Calendar.getInstance();
                calendar.setTime(df.parse(Utils.readCharacters(eventReader).replace(" ", "")));
                occurrence.setModified(calendar);
                continue;
            }
            if (Utils.checkStartElement(event, "decimalLatitude")) {
                occurrence.setDecimalLatitude(Double.parseDouble(Utils.readCharacters(eventReader).replace(" ", "")));
                continue;
            }
            if (Utils.checkStartElement(event, "decimalLongitude")) {
                occurrence.setDecimalLongitude(Double.parseDouble(Utils.readCharacters(eventReader).replace(" ", "")));
                continue;
            }
            if (Utils.checkStartElement(event, "nameComplete")) {
                occurrence.setScientificName(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "maximumDepthInMeters")) {
                occurrence.setMaxDepth(Double.parseDouble(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "minimumDepthInMeters")) {
                occurrence.setMinDepth(Double.parseDouble(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "coordinateUncertaintyInMeters")) {
                occurrence.setCountry(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "basisOfRecordString")) {
                String basisString = Utils.readCharacters(eventReader);
                occurrence.setBasisOfRecord(OccurrenceSearch.matchBasisOfRecord(basisString));
                continue;
            }
            if (Utils.checkStartElement(event, "citation")) {
                occurrence.setCitation(Utils.readCharacters(eventReader));
                continue;
            }
            if (!Utils.checkEndElement(event, "TaxonOccurrence")) continue;
            return occurrence;
        }
        throw new Exception("parsing exception");
    }
}

