package org.gcube.data.spd.gbifplugin.search;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.Constants;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public abstract class AbstractSearch<T> {

	private static GCUBELog logger = new GCUBELog(AbstractSearch.class);
	
	protected static XMLInputFactory ifactory = XMLInputFactory.newInstance();
	
	protected String providerKey;
	protected String dataSetKey;
	protected String elementsTag;
	protected Condition[] properties;
	
	public AbstractSearch(String elementsTag, Condition ... properties){
		this.elementsTag = elementsTag;
		this.properties =properties!=null?properties: new Condition[0];
	}
	
	protected synchronized void search(ObjectWriter<T> writer, URL searchUrl) throws Exception{
		logger.debug("starting search ");
		InputStream is =searchUrl.openConnection().getInputStream();
		XMLEventReader eventReader =
				ifactory.createXMLEventReader(is);
		try{
			String nextResultsLink= null;
			URL nextresultURL = null;
			logger.trace("searchURL is "+searchUrl);
			while (eventReader.hasNext()){
				XMLEvent event = eventReader.nextEvent();
				if (Utils.checkStartElement(event, "nextRequestUrl")){
					nextResultsLink = Utils.readCharacters(eventReader).replace(" ", "");
				} else if (Utils.checkStartElement(event, "dataProviders")){
					if(!pagingSearch(eventReader, writer)) break;
					if (nextResultsLink!=null){
						nextresultURL = new URL(nextResultsLink);
						logger.trace("nextURL: "+nextResultsLink);
						is =nextresultURL.openConnection().getInputStream();
						eventReader =
								ifactory.createXMLEventReader(is);
						nextResultsLink = null;
					}
				}
			}
		}finally{
			if (eventReader!=null) eventReader.close();
		}
		logger.debug("search finished ");
	}
	
	private boolean pagingSearch(XMLEventReader eventReader, ObjectWriter<T> writer) throws Exception{
		
		while(eventReader.hasNext()){
					
		    XMLEvent event = eventReader.nextEvent();

		    if(Utils.checkStartElement(event,"dataProvider"))
		    	if (!retrieveDataProvider(eventReader, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), writer))
		    			return false;
		
		    else if (Utils.checkEndElement(event,"dataProviders"))
		    	break;
		}
		return true;
	}
	
	private boolean retrieveDataProvider(XMLEventReader eventReader, String gbifKey, ObjectWriter<T> writer) throws Exception{
		List<T> elements = new ArrayList<T>();
		DataProvider dataProvider = new DataProvider(gbifKey);
		this.providerKey = gbifKey;
		while(eventReader.hasNext()){
			XMLEvent event = eventReader.nextEvent();
			if (Utils.checkStartElement(event, "name")){
				event = eventReader.nextEvent();
				dataProvider.setName(event.asCharacters().getData());
			}else if(Utils.checkStartElement(event, "dataResource")){
				elements.addAll(retrieveDataSet(eventReader, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(),event.asStartElement().getAttributeByName(Constants.ABOUT_ATTR).getValue(),dataProvider));
			}else if (Utils.checkEndElement(event, "dataProvider")){
				for (T element : elements){
					if (!writer.isAlive()){
						logger.trace("the writer for gbif is not alive");
						return false;
					}
					writer.write(element);
				}
				break;
			}
		}
		return true;
	}
	
	private List<T> retrieveDataSet(XMLEventReader eventReader, String resourceId, String resourceUri, DataProvider dataProvider) throws Exception{
		List<T> elements = new ArrayList<T>();
		//logger.trace("dataProvider is "+dataProvider.getName());
		this.dataSetKey= resourceId;
		DataSet dataSet = new DataSet(resourceId);
		dataSet.setDataProvider(dataProvider);	
			
		while(eventReader.hasNext()){
			XMLEvent event = eventReader.nextEvent();
			if (Utils.checkStartElement(event, "name")){
				dataSet.setName(Utils.readCharacters(eventReader));
			} else if (Utils.checkStartElement(event, "citation"))
				dataSet.setCitation(Utils.readCharacters(eventReader));
			else if (Utils.checkStartElement(event, this.elementsTag))
				elements = retrieveElements(eventReader, false, dataSet);
			else if (Utils.checkEndElement(event, "dataResource"))
				break;
			
		}
	
		return elements;
	}

	protected abstract List<T> retrieveElements(XMLEventReader eventReader, boolean b, DataSet dataset) throws Exception;
	
}
