package org.gcube.application.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.application.reporting.reference.ReferenceReportType;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.AttributeArea;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.RepeatableSequence;
import org.gcube.portlets.d4sreporting.common.shared.ReportReferences;
import org.gcube.portlets.d4sreporting.common.shared.Tuple;

public class ComponentBuilder {
	protected static final int COMP_WIDTH = ReportsModeler.TEMPLATE_WIDTH - 50;
	protected static final int COMP_HEIGHT = 35;
	
	
	protected static BasicComponent getTitle(String content, boolean isReadonly) {
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.TITLE, "", content, false, isReadonly, new ArrayList<Metadata>());		
	}
	
	protected static BasicComponent getTextInput(String content, boolean isReadonly, Metadata... properties) {
		List<Metadata> props = (properties != null) ? Arrays.asList(properties) : new ArrayList<Metadata>();
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.BODY_NOT_FORMATTED, "", content, false, isReadonly, props);	
	}
	
	protected static BasicComponent getHeading(int level, String content, boolean isReadonly) {
		ComponentType type;
		switch (level) {
		case 1:
			type = ComponentType.HEADING_1;
			break;
		case 2:
			type = ComponentType.HEADING_2;
			break;
		case 3:
			type = ComponentType.HEADING_3;
			break;
		case 4:
			type = ComponentType.HEADING_4;
			break;
		case 5:
			type = ComponentType.HEADING_5;
			break;

		default:
			throw new IllegalArgumentException("Only heading level between 1 and 5 are supported");
		}

		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, type, "", content, false, isReadonly, new ArrayList<Metadata>());	
	}
	
	protected static BasicComponent getAttributeArea(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) {
		ComponentType type = allowMultiselection ? ComponentType.ATTRIBUTE_MULTI : ComponentType.ATTRIBUTE_UNIQUE;
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 1, type, "", 
				new AttributeArea(attrName, values), false,	false, new ArrayList<Metadata>());
	}
	
	protected static BasicComponent getMedia() {
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.BODY_TABLE_IMAGE, "", null, false, true, new ArrayList<Metadata>());	
	}
	
	protected static BasicComponent getSequenceDelimiter(int height) {
		return new BasicComponent(0, 0, COMP_WIDTH, height, 
				1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", "", false, false, new ArrayList<Metadata>());	
	}
	
	protected static BasicComponent getInstruction(String content) {
		return new BasicComponent(0, 0, ComponentBuilder.COMP_WIDTH, ComponentBuilder.COMP_HEIGHT, 
				1, ComponentType.INSTRUCTION, "", content, false, false, new ArrayList<Metadata>());	
	}
	
	protected static BasicComponent getReference(ReferenceReport ref) {
		ReferenceReportType refType = ref.getRefType();
		List<DBTableRow> references = ref.getReferences();
		
		ArrayList<Tuple> msL = new ArrayList<Tuple>();
		for (DBTableRow dBTableRow : references) {
			ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
			groupedComponents.add(getSequenceDelimiter(5));
			for (Metadata md : dBTableRow.getMetadata()) {
				groupedComponents.add(ComponentBuilder.getHeading(dBTableRow.getHeadingLevel(), md.getAttribute(), true));
				groupedComponents.add(ComponentBuilder.getTextInput(md.getValue(), true));
			}
			groupedComponents.add(getSequenceDelimiter(5));
			msL.add(new Tuple(dBTableRow.getIdentifier(), groupedComponents));

		}
		ReportReferences toEmbed = new ReportReferences(refType.toString(), msL);
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.REPORT_REFERENCE, "", toEmbed, false, true, new ArrayList<Metadata>());	
	}

	
	protected static BasicComponent getSequence(String identifier, ReportSequence seq) {
		ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
		//need to add the delimiters at begin / end
		groupedComponents.add(getSequenceDelimiter(15));
		for (BasicComponent elem : seq.getSequence()) {
			groupedComponents.add(elem);
		}
		groupedComponents.add(getSequenceDelimiter(15));
		
		RepeatableSequence toEmbed = new RepeatableSequence(groupedComponents, identifier, 0);
		return new BasicComponent(0, 0, ComponentBuilder.COMP_WIDTH, ComponentBuilder.COMP_HEIGHT, 
				1, ComponentType.REPEAT_SEQUENCE, "", toEmbed, false, true, new ArrayList<Metadata>());	
	}
}
