package org.gcube.application.reporting;


/**
 * 
 * @author Massimiliano Assante - ISTI, CNR
 * 
 *
 */
public interface Modeler extends Sequentiable {
	/**
	 * add an empty fillable title
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTitle();
	/**
	 * 
	 * @param content the content you want to show in the title
	 * @param isReadonly tells wether the user can edit the content ot not
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTitle(String content, boolean isReadonly);
	/**
	 * add an instruction
	 * @param content the content you want to show in the instruction
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addInstruction(String content);
	/**
	 * add a sequence 
	 * @param identifier and identifier for this sequence
	 * @param ref @see {@link Sequentiable}   {@link ReportSequence} 
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addSequence(String identifier, ReportSequence seq);
	/**
	 * add the possibility to enter text, table or images in the report
	 * @return
	 */
	boolean addMedia();
	/**
	 * add a section, every add will point to this new section
	 * @return the index of the new section
	 */
	int nextSection();

}
