/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting.sequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.application.reporting.Property;
import org.gcube.application.reporting.Sequentiable;
import org.gcube.application.reporting.component.AbstractComponent;
import org.gcube.application.reporting.component.Box;
import org.gcube.application.reporting.component.BoxesArea;
import org.gcube.application.reporting.component.Heading;
import org.gcube.application.reporting.component.Instruction;
import org.gcube.application.reporting.component.ReportComponent;
import org.gcube.application.reporting.component.TextInput;
import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.RepeatableSequence;

public class ReportSequence
extends AbstractComponent
implements Sequentiable {
    private List<BasicComponent> sequence;
    private List<ReportComponent> children;

    public ReportSequence(String id) {
        this.setId(id);
        this.sequence = new ArrayList<BasicComponent>();
        this.children = new ArrayList<ReportComponent>();
    }

    @Override
    public boolean addHeading(int level) throws IllegalArgumentException {
        return this.addHeading(level, "", false);
    }

    @Override
    public boolean addHeading(int level, String content) throws IllegalArgumentException {
        return this.addHeading(level, content, false);
    }

    @Override
    public boolean addHeading(int level, String content, boolean isReadonly) throws IllegalArgumentException {
        Heading toAdd = new Heading(level, content, isReadonly);
        this.children.add(toAdd);
        this.sequence.add(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addTextInput(Property ... properties) {
        return this.addTextInput("", false, properties);
    }

    @Override
    public boolean addTextInput(String content, Property ... properties) {
        return this.addTextInput("", false, properties);
    }

    @Override
    public boolean addTextInput(String content, boolean isReadOnly, Property ... properties) {
        TextInput toAdd = new TextInput(content, isReadOnly);
        toAdd.setProperties(properties != null ? Arrays.asList(properties) : new ArrayList<Property>());
        this.children.add(toAdd);
        this.sequence.add(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection) {
        BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
        this.sequence.add(toAdd.getModelComponent());
        this.children.add(toAdd);
        return true;
    }

    @Override
    public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection, Property ... properties) {
        BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
        toAdd.setProperties(properties != null ? Arrays.asList(properties) : new ArrayList<Property>());
        this.sequence.add(toAdd.getModelComponent());
        this.children.add(toAdd);
        return true;
    }

    @Override
    public boolean addReference(ReferenceReport ref) {
        this.sequence.add(ref.getModelComponent());
        this.children.add(ref);
        return true;
    }

    @Override
    public boolean addInstruction(String content) {
        this.sequence.add(new Instruction(content).getModelComponent());
        return true;
    }

    public List<BasicComponent> getSequence() {
        return this.sequence;
    }

    @Override
    public ReportComponentType getType() {
        return ReportComponentType.SEQUENCE;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public List<ReportComponent> getChildren() {
        return this.children;
    }

    @Override
    public String getStringValue() {
        return null;
    }

    @Override
    public BasicComponent getModelComponent() {
        ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
        groupedComponents.add(this.getSequenceDelimiter(15));
        for (BasicComponent elem : this.getSequence()) {
            groupedComponents.add(elem);
        }
        groupedComponents.add(this.getSequenceDelimiter(15));
        RepeatableSequence toEmbed = new RepeatableSequence(groupedComponents, this.getId(), 0);
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.REPEAT_SEQUENCE, "", (Serializable)toEmbed, false, true, this.convertProperties());
    }

    private BasicComponent getSequenceDelimiter(int height) {
        return new BasicComponent(0, 0, 700, height, 1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", (Serializable)((Object)""), false, false, new ArrayList());
    }
}

