/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting.reference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.reporting.component.AbstractComponent;
import org.gcube.application.reporting.component.Heading;
import org.gcube.application.reporting.component.TextInput;
import org.gcube.application.reporting.component.interfaces.IsSequentiable;
import org.gcube.application.reporting.component.interfaces.ReportComponent;
import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.application.reporting.reference.Column;
import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.application.reporting.reference.ReferenceReportType;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.ReportReferences;
import org.gcube.portlets.d4sreporting.common.shared.Tuple;

public class ReferenceReport
extends AbstractComponent
implements IsSequentiable {
    private ReferenceReportType refType;
    private boolean singleRelation;
    private List<DBTableRow> references;

    public ReferenceReport(ReferenceReportType refType, List<DBTableRow> references) {
        this(refType, references, false);
    }

    public ReferenceReport(String id, ReferenceReportType refType, List<DBTableRow> references) {
        this(id, refType, references, false);
    }

    public ReferenceReport(String id, ReferenceReportType refType, List<DBTableRow> references, boolean singleRelation) {
        this(refType, references, singleRelation);
        this.setId(id);
    }

    public ReferenceReport(ReferenceReportType refType, List<DBTableRow> references, boolean singleRelation) {
        this.refType = refType;
        this.references = references;
        this.singleRelation = singleRelation;
    }

    public boolean isSingleRelation() {
        return this.singleRelation;
    }

    public ReferenceReportType getRefType() {
        return this.refType;
    }

    public void setRefType(ReferenceReportType refType) {
        this.refType = refType;
    }

    public List<DBTableRow> getReferences() {
        return this.references;
    }

    @Override
    public ReportComponentType getType() {
        return ReportComponentType.REFERENCE;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public List<ReportComponent> getChildren() {
        ArrayList<ReportComponent> toReturn = new ArrayList<ReportComponent>();
        toReturn.addAll(this.references);
        return toReturn;
    }

    @Override
    public String getStringValue() {
        return null;
    }

    @Override
    public BasicComponent getModelComponent() {
        List<DBTableRow> references = this.getReferences();
        ArrayList<Tuple> msL = new ArrayList<Tuple>();
        for (DBTableRow dBTableRow : references) {
            ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
            groupedComponents.add(this.getSequenceDelimiter(5));
            for (Column col : dBTableRow.getColumns()) {
                groupedComponents.add(new Heading(dBTableRow.getHeadingLevel(), col.getName(), true).getModelComponent());
                groupedComponents.add(new TextInput(col.getValue(), true).getModelComponent());
            }
            groupedComponents.add(this.getSequenceDelimiter(5));
            msL.add(new Tuple(dBTableRow.getId(), groupedComponents));
        }
        ReportReferences toEmbed = new ReportReferences(this.refType.toString(), msL, this.singleRelation);
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, ComponentType.REPORT_REFERENCE, "", (Serializable)toEmbed, false, true, this.convertProperties());
        bc.setId(this.getId());
        return bc;
    }

    private BasicComponent getSequenceDelimiter(int height) {
        return new BasicComponent(0, 0, 700, height, 1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", (Serializable)((Object)""), false, false, new ArrayList());
    }
}

