package org.gcube.application.geoportal.client;

import javax.ws.rs.client.WebTarget;

import org.gcube.application.geoportal.client.legacy.ConcessioniPlugin;
import org.gcube.application.geoportal.common.rest.ConcessioniI;
import org.gcube.application.geoportal.common.rest.InterfaceConstants;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.ProxyBuilder;
import org.gcube.common.clients.ProxyBuilderImpl;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public abstract class GeoportalAbstractPlugin <S, P> implements Plugin<S, P>{


	private static ConcessioniPlugin concessioni_plugin=new ConcessioniPlugin();
	
	public static ProxyBuilder<ConcessioniI> concessioni() {
	    return new ProxyBuilderImpl<WebTarget,ConcessioniI>(concessioni_plugin);
	}

	private String name;
	
	
	
	@Override
	public String name() {
		return this.name;
	}

	@Override
	public String namespace() {
		return InterfaceConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return InterfaceConstants.SERVICE_CLASS;
	}

	@Override
	public String serviceName() {
		return InterfaceConstants.SERVICE_NAME;
	}

	
	
}
