/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.legacy;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gcube.application.geoportal.client.GeoportalAbstractPlugin;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.InputStreamDescriptor;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.UploadedImage;
import org.gcube.application.geoportal.common.model.legacy.report.PublicationReport;
import org.gcube.application.geoportal.common.rest.ConcessioniI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioniManager {
    private static final Logger log = LoggerFactory.getLogger(ConcessioniManager.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectReader concessioniReader = null;
    private static ObjectReader collectionReader = null;
    private ConcessioniI service = (ConcessioniI)GeoportalAbstractPlugin.concessioni().build();
    private Concessione lastRegistered;

    public Concessione getById(String id) throws Exception {
        log.info("Reading by ID " + id);
        try {
            String result = this.service.readById(id);
            log.debug("Reading json object : " + result);
            return (Concessione)concessioniReader.readValue(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String toJson(Object obj) throws JsonProcessingException {
        return mapper.writeValueAsString(obj);
    }

    public ArrayList<Concessione> getList() throws Exception {
        log.info("Getting list");
        try {
            String result = this.service.getAll();
            log.debug("Reading json object : " + result);
            Collection coll = (Collection)collectionReader.readValue(result);
            ArrayList<Concessione> toReturn = new ArrayList<Concessione>();
            for (String s : coll) {
                toReturn.add((Concessione)concessioniReader.readValue(s));
            }
            return toReturn;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Concessione registerNew(Concessione c) throws Exception {
        try {
            String response = this.service.create(mapper.writeValueAsString((Object)c));
            this.lastRegistered = (Concessione)concessioniReader.readValue(response);
            return this.lastRegistered;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setRelazioneScavo(RelazioneScavo rel, InputStreamDescriptor theFile) {
    }

    public void addImmagineRappresentativa(UploadedImage img, InputStreamDescriptor theFile) {
    }

    public void setPosizionamento(LayerConcessione layer, InputStreamDescriptor ... inputStreams) {
    }

    public void addPiantaScavo(LayerConcessione layer, InputStreamDescriptor ... inputStreams) {
    }

    public PublicationReport commitRegistered() {
        return null;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        concessioniReader = mapper.readerFor(Concessione.class);
        collectionReader = mapper.readerFor(Collection.class);
    }
}

