/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.legacy;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.ws.rs.client.WebTarget;
import org.gcube.application.geoportal.client.DefaultMongoConcessioni;
import org.gcube.application.geoportal.client.legacy.ConcessioniManagerI;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.InputStreamDescriptor;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.UploadedImage;
import org.gcube.application.geoportal.common.model.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.common.rest.TempFile;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class StatefulMongoConcessioni
extends DefaultMongoConcessioni
implements ConcessioniManagerI {
    private Concessione currentC = null;
    private StorageUtils storage = new StorageUtils();

    public StatefulMongoConcessioni(ProxyDelegate<WebTarget> delegate) {
        super(delegate);
    }

    @Override
    public Concessione createNew(Concessione c) throws Exception {
        this.currentC = super.createNew(c);
        return this.currentC;
    }

    @Override
    public Concessione getById(String id) throws Exception {
        this.currentC = super.getById(id);
        return this.currentC;
    }

    @Override
    public Concessione publish() throws Exception {
        if (this.currentC == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.currentC = super.publish(this.currentC.getMongo_id());
        return this.currentC;
    }

    @Override
    public void delete() throws Exception {
        if (this.currentC == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        super.deleteById(this.currentC.getMongo_id());
        this.currentC = null;
    }

    @Override
    public Concessione addImmagineRappresentativa(UploadedImage toAdd, TempFile f) throws Exception {
        if (this.currentC == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        if (this.currentC.getImmaginiRappresentative() == null) {
            this.currentC.setImmaginiRappresentative(new ArrayList());
        }
        this.currentC.getImmaginiRappresentative().add(toAdd);
        this.currentC = this.replace(this.currentC);
        this.currentC = super.registerFile(this.currentC.getMongo_id(), StatefulMongoConcessioni.request(Concessione.Paths.imgByIndex((int)(this.currentC.getImmaginiRappresentative().size() - 1)), f));
        return this.currentC;
    }

    @Override
    public Concessione addPiantaFineScavo(LayerConcessione toAdd, TempFile ... files) throws Exception {
        if (this.currentC == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        if (this.currentC.getPianteFineScavo() == null) {
            this.currentC.setPianteFineScavo(new ArrayList());
        }
        this.currentC.getPianteFineScavo().add(toAdd);
        this.currentC = this.replace(this.currentC);
        this.currentC = super.registerFile(this.currentC.getMongo_id(), StatefulMongoConcessioni.request(Concessione.Paths.piantaByIndex((int)(this.currentC.getPianteFineScavo().size() - 1)), files));
        return this.currentC;
    }

    @Override
    public Concessione setPosizionamento(LayerConcessione toSet, TempFile ... files) throws Exception {
        if (this.currentC == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.currentC.setPosizionamentoScavo(toSet);
        this.currentC = this.replace(this.currentC);
        this.currentC = super.registerFile(this.currentC.getMongo_id(), StatefulMongoConcessioni.request("posizionamentoScavo", files));
        return this.currentC;
    }

    @Override
    public Concessione setRelazioneScavo(RelazioneScavo toSet, TempFile f) throws Exception {
        if (this.currentC == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.currentC.setRelazioneScavo(toSet);
        this.currentC = this.replace(this.currentC);
        this.currentC = super.registerFile(this.currentC.getMongo_id(), StatefulMongoConcessioni.request("relazione", f));
        return this.currentC;
    }

    @Override
    public Concessione addImmagineRappresentativa(UploadedImage toAdd, InputStreamDescriptor f) throws Exception {
        return this.addImmagineRappresentativa(toAdd, this.asTemp(f));
    }

    @Override
    public Concessione addPiantaFineScavo(LayerConcessione toAdd, InputStreamDescriptor ... files) throws Exception {
        return this.addPiantaFineScavo(toAdd, this.asTemp(files));
    }

    @Override
    public Concessione setPosizionamento(LayerConcessione toSet, InputStreamDescriptor ... files) throws Exception {
        return this.setPosizionamento(toSet, this.asTemp(files));
    }

    @Override
    public Concessione setRelazioneScavo(RelazioneScavo toSet, InputStreamDescriptor f) throws Exception {
        return this.setRelazioneScavo(toSet, this.asTemp(f));
    }

    protected static AddSectionToConcessioneRequest request(String path, TempFile ... files) {
        AddSectionToConcessioneRequest req = new AddSectionToConcessioneRequest();
        req.setDestinationPath(path);
        req.setStreams(new ArrayList());
        for (TempFile f : files) {
            req.getStreams().add(f);
        }
        return req;
    }

    protected TempFile asTemp(InputStreamDescriptor descriptor) throws RemoteBackendException, FileNotFoundException {
        return this.storage.putOntoStorage(descriptor.getStream(), descriptor.getFilename());
    }

    protected TempFile[] asTemp(InputStreamDescriptor ... descriptors) throws RemoteBackendException, FileNotFoundException {
        ArrayList<TempFile> toReturn = new ArrayList<TempFile>();
        for (InputStreamDescriptor desc : descriptors) {
            toReturn.add(this.storage.putOntoStorage(desc.getStream(), desc.getFilename()));
        }
        return toReturn.toArray(new TempFile[toReturn.size()]);
    }
}

