/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.client.WebTarget;
import org.gcube.application.geoportal.client.DefaultMongoConcessioni;
import org.gcube.application.geoportal.client.legacy.ConcessioniManagerI;
import org.gcube.application.geoportal.common.model.legacy.AbstractRelazione;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.InputStreamDescriptor;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.UploadedImage;
import org.gcube.application.geoportal.common.model.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.common.model.rest.TempFile;
import org.gcube.application.geoportal.common.utils.FileSets;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.common.clients.delegates.ProxyDelegate;

public class StatefulMongoConcessioni
extends DefaultMongoConcessioni
implements ConcessioniManagerI {
    private Concessione current = null;
    private StorageUtils storage = new StorageUtils();

    public StatefulMongoConcessioni(ProxyDelegate<WebTarget> delegate) {
        super(delegate);
    }

    @Override
    public Concessione createNew(Concessione c) throws Exception {
        this.current = super.createNew(c);
        return this.current;
    }

    @Override
    public Concessione getById(String id) throws Exception {
        this.current = super.getById(id);
        return this.current;
    }

    @Override
    public Concessione publish() throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.current = super.publish(this.current.getMongo_id());
        return this.current;
    }

    @Override
    public void delete() throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        super.deleteById(this.current.getMongo_id());
        this.current = null;
    }

    @Override
    public Concessione addImmagineRappresentativa(UploadedImage toAdd, TempFile f) throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        if (this.current.getImmaginiRappresentative() == null) {
            this.current.setImmaginiRappresentative(new ArrayList());
        }
        this.current.getImmaginiRappresentative().add(toAdd);
        this.current = this.replace(this.current);
        AddSectionToConcessioneRequest req = new AddSectionToConcessioneRequest();
        req.setDestinationPath(Concessione.Paths.imgByIndex((int)(this.current.getImmaginiRappresentative().size() - 1)));
        req.setStreams(Collections.singletonList(f));
        this.current = super.registerFileSet(this.current.getMongo_id(), req);
        return this.current;
    }

    @Override
    public Concessione addPiantaFineScavo(LayerConcessione toAdd, TempFile ... files) throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        if (this.current.getPianteFineScavo() == null) {
            this.current.setPianteFineScavo(new ArrayList());
        }
        this.current.getPianteFineScavo().add(toAdd);
        this.current = this.replace(this.current);
        AddSectionToConcessioneRequest req = new AddSectionToConcessioneRequest();
        req.setDestinationPath(Concessione.Paths.piantaByIndex((int)(this.current.getPianteFineScavo().size() - 1)));
        req.setStreams(Arrays.asList(files));
        this.current = super.registerFileSet(this.current.getMongo_id(), req);
        return this.current;
    }

    @Override
    public Concessione setPosizionamento(LayerConcessione toSet, TempFile ... files) throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.current.setPosizionamentoScavo(toSet);
        this.current = this.replace(this.current);
        AddSectionToConcessioneRequest req = new AddSectionToConcessioneRequest();
        req.setDestinationPath("posizionamentoScavo");
        req.setStreams(Arrays.asList(files));
        this.current = super.registerFileSet(this.current.getMongo_id(), req);
        return this.current;
    }

    @Override
    public Concessione setRelazioneScavo(RelazioneScavo toSet, TempFile ... files) throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.current.setRelazioneScavo(toSet);
        this.current = this.replace(this.current);
        AddSectionToConcessioneRequest req = new AddSectionToConcessioneRequest();
        req.setDestinationPath("relazione");
        req.setStreams(Arrays.asList(files));
        this.current = super.registerFileSet(this.current.getMongo_id(), req);
        return this.current;
    }

    @Override
    public Concessione setAbstractRelazioneScavo(AbstractRelazione toSet, TempFile ... files) throws Exception {
        if (this.current == null) {
            throw new Exception("Invalid operation : current Concessione is null.");
        }
        this.current.setAbstractRelazione(toSet);
        this.current = this.replace(this.current);
        AddSectionToConcessioneRequest req = new AddSectionToConcessioneRequest();
        req.setDestinationPath("abstract_relazione");
        req.setStreams(Arrays.asList(files));
        this.current = super.registerFileSet(this.current.getMongo_id(), req);
        return this.current;
    }

    @Override
    public Concessione addImmagineRappresentativa(UploadedImage toAdd, InputStreamDescriptor f) throws Exception {
        return this.addImmagineRappresentativa(toAdd, FileSets.asTemp((StorageUtils)this.storage, (InputStreamDescriptor)f));
    }

    @Override
    public Concessione addPiantaFineScavo(LayerConcessione toAdd, InputStreamDescriptor ... files) throws Exception {
        return this.addPiantaFineScavo(toAdd, FileSets.asTemp((StorageUtils)this.storage, (InputStreamDescriptor[])files));
    }

    @Override
    public Concessione setPosizionamento(LayerConcessione toSet, InputStreamDescriptor ... files) throws Exception {
        return this.setPosizionamento(toSet, FileSets.asTemp((StorageUtils)this.storage, (InputStreamDescriptor[])files));
    }

    @Override
    public Concessione setRelazioneScavo(RelazioneScavo toSet, InputStreamDescriptor f) throws Exception {
        return this.setRelazioneScavo(toSet, FileSets.asTemp((StorageUtils)this.storage, (InputStreamDescriptor)f));
    }

    @Override
    public Concessione setAbstractRelazioneScavo(AbstractRelazione toSet, InputStreamDescriptor f) throws Exception {
        return this.setAbstractRelazioneScavo(toSet, FileSets.asTemp((StorageUtils)this.storage, (InputStreamDescriptor)f));
    }

    @Override
    public Concessione getCurrent() {
        return this.current;
    }
}

