/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.plugins;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import javax.ws.rs.client.WebTarget;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import lombok.NonNull;
import org.gcube.application.geoportal.client.DefaultDocumentsClient;
import org.gcube.application.geoportal.client.plugins.GeoportalAbstractPlugin;
import org.gcube.application.geoportal.client.utils.Serialization;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.rest.Projects;
import org.gcube.common.calls.jaxrs.GcubeService;
import org.gcube.common.calls.jaxrs.TargetFactory;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ProjectsInterfacePlugin<C extends DefaultDocumentsClient, P extends Project>
extends GeoportalAbstractPlugin<WebTarget, Projects<P>> {
    private static final Logger log = LoggerFactory.getLogger(ProjectsInterfacePlugin.class);
    @NonNull
    private String profileID;
    private Class<C> customClientImplementation = DefaultDocumentsClient.class;
    private Class<P> profiledModel = Project.class;

    @Override
    public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
        return fault;
    }

    public Projects<P> newProxy(ProxyDelegate<WebTarget> delegate) {
        return (Projects)this.customClientImplementation.getConstructor(ProxyDelegate.class, String.class, Class.class).newInstance(delegate, this.profileID, this.profiledModel);
    }

    public WebTarget resolve(EndpointReference address, ProxyConfig<?, ?> config) throws Exception {
        DOMResult result = new DOMResult();
        address.writeTo((Result)result);
        Node node = result.getNode();
        Node child = node.getFirstChild();
        String addressString = child.getTextContent();
        GcubeService service = GcubeService.service().withName(new QName("http://gcube-system.org/namespaces/data/sdi-service", "projects")).andPath("projects");
        WebTarget target = TargetFactory.stubFor((GcubeService)service).at(addressString);
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(Serialization.mapper);
        target.register((Object)provider);
        return target;
    }

    public ProjectsInterfacePlugin(@NonNull String profileID) {
        if (profileID == null) {
            throw new NullPointerException("profileID is marked @NonNull but is null");
        }
        this.profileID = profileID;
    }

    public void setCustomClientImplementation(Class<C> customClientImplementation) {
        this.customClientImplementation = customClientImplementation;
    }

    public void setProfiledModel(Class<P> profiledModel) {
        this.profiledModel = profiledModel;
    }
}

