package org.gcube.application.geoportal.common.rest;

import java.rmi.RemoteException;

import org.gcube.application.geoportal.common.model.project.Project;

public interface ProjectsI {

	
	public Iterable<Project> getAll() throws RemoteException;
	public Iterable<Project> getByProfile(String profileId) throws RemoteException;
	public Project getById(String profileId,String id) throws RemoteException;
	public Iterable<Project> getByFilter(String filter)throws RemoteException;
	public Iterable<Project> getByFilter(String filter, String profileId)throws RemoteException;
	public Project registrNew(String profileId, String jsonDocument)throws RemoteException;
	public Project update(String profileId, String projectId,String jsonDocument) throws RemoteException;
	public void deleteById(String profileId, String projectId)throws RemoteException;
}
